% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lets_midpoint.R
\name{lets.midpoint}
\alias{lets.midpoint}
\title{Compute the midpoint of species' geographic ranges}
\usage{
lets.midpoint(pam, planar = FALSE, method = "GM")
}
\arguments{
\item{pam}{A presence-absence \code{matrix} (sites in the rows and species
in the columns, with the first two columns containing the longitudinal
and latitudinal coordinates, respectively), or an object of class 
\code{\link{PresenceAbsence}}.}

\item{planar}{Logical, if \code{FALSE} the coordinates are in Longitude/Latitude.
If \code{TRUE} the coordinates are planar.}

\item{method}{Users can choose between the geographic midpoint (or center of gravity), 
using the option "GM". Alternatively, the midpoint can be calculated as the point
that minimize the distance between all cells of the PAM (center of minimun distance),
using the method "CMD".}
}
\value{
A \code{data.frame} containing the species' names and geographic coordinates 
(longitude [x], latitude [y]) of species' midpoints.
}
\description{
Calculate species' distributional midpoint from a 
presence-absence matrix.
}
\examples{
\dontrun{
data(PAM)
mid <- lets.midpoint(PAM)
} 

}
\seealso{
\code{\link{lets.presab}}

\code{\link{lets.presab.birds}}
}
\author{
Fabricio Villalobos & Bruno Vilela
}
