\name{global}
\alias{global}
\alias{theme}
\alias{set}

\title{Set the Default Color Theme and Other System Settings}

\description{
Deprecated Names: \code{set}, \code{theme}

Each graph is based on a default color theme. The original default is \code{colors="dodgerblue"}, but \code{global} allows other color palettes to be set as default as well. Setting \code{ghost=TRUE} provides transparency effects against a black background. Other system settings are also available.}

\usage{
global(colors=c("blue", "gray", "rose", "green", "gold", "red", "darkred",
         "dodgerblue", "purple", "sienna", "brown", "orange.black",
         "gray.black", "white"),

         fill.bar=NULL, fill.pt=NULL,
         trans=NULL, trans.fill.bar=NULL, trans.fill.pt=NULL,
         stroke.bar=NULL, stroke.pt=NULL,
         se.fill=NULL, fill.ellipse=NULL,
         bg=NULL, grid=NULL, box=NULL,
         heat=NULL, ghost=NULL,

         n.cat=getOption("n.cat"), lab.size=getOption("lab.size"),
         suggest=getOption("suggest"),
         quiet=getOption("quiet"), brief=getOption("brief"),

         results=getOption("results"), explain=getOption("explain"),
         interpret=getOption("interpret"), document=getOption("document"), 
         code=getOption("code"),

         width=120, show=FALSE)

theme(\ldots)
set(\ldots)
}


\arguments{
  \item{colors}{The specified color scheme.}
  \item{fill.bar}{Color of a filled region, such as a histogram bar.}
  \item{fill.pt}{Color of a filled region, such as a plotted point.}
  \item{trans}{Transparency of a filled bar or rectangular region and points.}
  \item{trans.fill.bar}{The transparency of a filled bar or rectangular region,
       such as a histogram bar or the box in a box plot. Value from 0 to 1,
       opaque to transparent.}
  \item{trans.fill.pt}{The transparency of the inner region of a plotted point.
       Value from 0 to 1, opaque to transparent.}
  \item{stroke.bar}{Color of the border of a filled region such as a histogram
       bar.}
  \item{stroke.pt}{Color of a line or outline of a filled region, such as the
       border of a plotted point.}
  \item{se.fill}{Color of the fill for the standard error plot about a
       fit line in a scatter plot.}
  \item{fill.ellipse}{Color of the fill for an ellipse in a scatter plot.}
  \item{bg}{Color of the plot background.}
  \item{grid}{Color of the grid lines.}
  \item{box}{Color of border around the plot background, the box, that encloses 
        the plot, with a default of \code{"black"}.}
  \item{heat}{Color of the heat map for correlation matrices.}
  \item{ghost}{If \code{TRUE}, add a black background, transparent grid lines
       and transparency for the bars. Overrides individual settings for
       those values. Setting to \code{FALSE} has no effect.}
  \item{n.cat}{Number of categories that specifies the largest number of unique
        equally-spaced values of variable of a numeric data type for which the
        variable will be analyzed as categorical. Applies to
        \code{\link{ScatterPlot}} and 
        \code{\link{SummaryStats}}, and also to the functions such as 
        \code{\link{Histogram}} when processing multiple graphs.}
  \item{lab.size}{Size of labels for x and y axes.}
  \item{suggest}{If \code{TRUE}, then provide suggestions for alternative analyses.}
  \item{quiet}{If \code{TRUE} then some functions suppress console output.}
  \item{brief}{If set to \code{TRUE}, reduced text output.}
  \item{results}{For the R markdown file generated by the knitr.file option, 
        show the results.}
  \item{explain}{For the R markdown file generated by the knitr.file option, 
        explain the results.}
  \item{interpret}{For the R markdown file generated by the knitr.file option, 
        interpret the results.}
  \item{document}{For the R markdown file generated by the knitr.file option,
        documents the code that generated the results.} 
  \item{code}{For the R markdown file generated by the knitr.file option, 
        shows the code that generated the results.}
  \item{width}{Maximum width of each line displayed at the console, just accesses
        the standard R options function for width.}
  \item{show}{Option for showing all settings.}
  \item{\dots}{Parameter values.}
}


\details{
Sets the default color palette via the R \code{\link{options}} statement, as well as the transparency of plotted bars and points. Each time \code{colors} is reset, the specific color options are reset to their default values, which includes a transparency fill for plotted points of 0.66.

The gray color scheme is based on the colors used in Hadley Wickham's \code{ggplot2} package.

Set \code{ghost=TRUE} is equivalent to setting \code{bg} to \code{"black"} and \code{grid} to \code{"transparent"} with a bar transparency of 0.7. It overrides these settings individually, so must turn \code{ghost=FALSE} and set each of the three settings individually to change from the standard \code{ghost} settings.}

\author{David W. Gerbing (Portland State University; \email{gerbing@pdx.edu})}

\references{
Wickham, Hadley, ggplot2: Elegant Graphics for Data Analysis, 2nd edition, Springer, 2009.
}

\seealso{
\code{\link{options}}.
}

\examples{
# set all subsequent graphic output to gray scale
global(colors="gray")

# define a custom color theme: sienna
# this works regardless of the set color theme because
#   all of the individual components of the theme are changed
# the trans options are the default values, so not necessary to
#   set unless already changed previously
# the three ghost settings - trans.fill.bar, grid and bg --
#   must be manually entered to achieve  a ghost plot
global(fill.bar="seagreen3")
global(fill.pt="seagreen3")
global(stroke.bar="seagreen4")
global(stroke.pt="seagreen4")
global(bg="seashell1")
global(grid="seashell2")
global(trans.fill.bar=.00)
global(trans.fill.pt=.66)

# all numeric variables with 8 or less unique values and equally spaced
#  intervals are analyzed as categorical variables
global(n.cat=8)}


% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ sets }
\keyword{ csv }


