% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-annotation.r
\name{annotate_y_axis}
\alias{annotate_y_axis}
\alias{annotate_x_axis}
\title{Annotations in the axis}
\usage{
annotate_y_axis(
  label,
  y,
  side = waiver(),
  print_label = TRUE,
  print_value = TRUE,
  print_both = TRUE,
  parsed = FALSE,
  ...
)

annotate_x_axis(
  label,
  x,
  side = waiver(),
  print_label = TRUE,
  print_value = TRUE,
  print_both = TRUE,
  parsed = FALSE,
  ...
)
}
\arguments{
\item{label}{Text to print}

\item{y, x}{Position of the annotation.}

\item{side}{left or right, or top or bottom side to print annotation}

\item{print_label, print_value, print_both}{Logical; what to show on annotation. Label and/or value.
\code{print_both} is shortcut for setting both \code{print_label} and
\code{print_value}. When both is TRUE, uses argument \code{sep} to 
separate the label and value.}

\item{parsed}{Logical (default \code{FALSE}), 
when \code{TRUE}, uses mathplot for outputting expressions. 
See section "Showing values".}

\item{...}{Style settings for label and tick: 
colour, hjust, vjust, size, fontface, family, rot. 
When \code{waiver()} (default),
the relevant theme element is used.}
}
\description{
Annotations in the axis
}
\section{}{
 Showing values:
See \link[grDevices]{plotmath} for using mathematical expressions.
The function uses a simple replacement strategy where the literal strings
\code{.(y)} and \code{.(val)} are replaced by the value after round of to
a number of digits, as given by argument \code{digits}.
}

\examples{
library(ggplot2)

p <- ggplot(mtcars, aes(mpg, hp, colour=disp)) + geom_point()

l <- p + annotate_y_axis('mark at', y=200, tick=TRUE)
l

(l + annotate_x_axis('| good economy ->', x=25, print_value=FALSE, hjust=0, tick=TRUE))

l + annotate_y_axis("x^2 == .(y)", y=180, parsed=FALSE,  tick=FALSE) +
    annotate_y_axis("x^2 + bar(x) == .(y)", y=mean(mtcars$hp), parsed=TRUE, tick=TRUE)

l + annotate_y_axis("bar(x) == .(y)", y = mean(mtcars$hp),  parsed=TRUE, tick=FALSE) 
# use double equal signs, or the output becomes '=(...)' for some reason.

l + annotate_y_axis('this is midway', y=sum(range(mtcars$hp))/2, print_value = FALSE, side='left')

# work around if an axis only contains parsed expressions
p + annotate_y_axis("some long string", y=100, tick=FALSE, print_value=FALSE, colour=NA) +
  annotate_y_axis("bar(x) == .(y)", y = mean(mtcars$hp),  parsed=TRUE, tick=FALSE)
  


# Works together with other functions
p <- p + theme_light() + theme(panel.border=element_blank(),
                               axis.line = element_line(), 
                               axis.ticks = element_line(colour='black')) 
p + coord_capped_cart(bottom='right') + 
  annotate_y_axis('More than I\ncan afford', y=125, 
                  print_value=FALSE, tick=TRUE)
}
