% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primitive-line.R
\name{primitive_line}
\alias{primitive_line}
\title{Guide primitive: line}
\usage{
primitive_line(key = NULL, cap = "none", theme = NULL, position = waiver())
}
\arguments{
\item{key}{A \link[=key_standard]{standard key} specification. See more information
in the linked topic.}

\item{cap}{A method to cap the axes. One of the following:
\itemize{
\item A \verb{<character[1]>} with one of the following:
\itemize{
\item \code{"none"} to perform no capping.
\item \code{"both"} to cap the line at both ends at the most extreme breaks.
\item \code{"upper"} to cap the line at the upper extreme break.
\item \code{"lower"} to cap the line at the lower extreme break.
}
\item A \verb{<logical>[1]}, where \code{TRUE} is equivalent to \code{"both"} and \code{FALSE}
is equivalent to \code{"none"} in the options above.
\item A sorted \verb{<numeric>[2n]} with an even number of members. The lines
will be drawn between every odd-even pair.
\item A \verb{<function>} that takes the scale's breaks as the first argument, the
scale's limits as the second argument and returns a \verb{<numeric>[2n]} as
described above.
}}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}
}
\value{
A \code{PrimitiveLine} primitive guide that can be used inside other
guides.
}
\description{
This function constructs a line \link[=guide-primitives]{guide primitive}.
}
\section{Styling options}{
Below are the \link[ggplot2:theme]{theme} options that determine the styling of
this guide, which may differ depending on whether the guide is used in
an axis or in a legend context.
\subsection{As an axis guide}{
\itemize{
\item \verb{axis.line.\{x/y\}.\{position\}} an \code{\link[ggplot2:element]{<element_line>}}
for the line style.
}
}

\subsection{As a legend guide}{
\itemize{
\item \code{legend.axis.line} an \code{\link[ggplot2:element]{<element_line>}} for the
line style.
}
}
}

\examples{
# A standard plot
p <- ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  theme(axis.line = element_line())

# Adding as secondary guides
p + guides(
  x.sec = primitive_line(),
  y.sec = primitive_line(cap = "both")
)
}
\seealso{
Other primitives: 
\code{\link{primitive_box}()},
\code{\link{primitive_bracket}()},
\code{\link{primitive_fence}()},
\code{\link{primitive_labels}()},
\code{\link{primitive_spacer}()},
\code{\link{primitive_ticks}()},
\code{\link{primitive_title}()}
}
\concept{primitives}
