% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixcreation.R
\name{summary.lefkoMatList}
\alias{summary.lefkoMatList}
\title{Summary of Class "lefkoMatList"}
\usage{
\method{summary}{lefkoMatList}(
  object,
  elem_summaries = FALSE,
  colsums = TRUE,
  check_cycle = TRUE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{lefkoMatList}.}

\item{elem_summaries}{A logical value indicating whether to include
summaries of all \code{lefkoMat} elements within the input
\code{lefkoMatList} object. Defaults to \code{FALSE}.}

\item{colsums}{If \code{elem_summaries = TRUE}, then this is a logical value
indicating whether column sums should be shown for U matrices, allowing users
to check stage survival probabilities. Defaults to \code{TRUE}.}

\item{check_cycle}{If \code{elem_summaries = TRUE}, then this is a logical
value indicating whether to test matrices for stage discontinuities in the
life cycle. Defaults to \code{TRUE}.}

\item{...}{Other parameters.}
}
\value{
A general summary of the \code{lefkoMatList} object, showing the
number and type of \code{lefkoMat} objects included, the mean number of
annual matrices per \code{lefkoMat} element, the mean size of each matrix,
the mean number of estimated (non-zero) elements across all matrices and per
matrix, the mean number of unique transitions in the bootstrapped datasets,
the mean number of individuals, and summaries of the column sums of the survival-transition
matrices across all \code{lefkoMat} objects.

if \code{elem_summaries = TRUE}, then \code{\link{summary.lefkoMat}{}} output
is also shown for each \code{lefkoMat} object per entered \code{lefkoMatList}
object.

Stage discontinuities may also be also checked across all \code{lefkoMat}
objects with function \code{cycle_check}. This function will also yield
warnings if any survival-transition matrices include elements outside of the
interval [0,1], if any fecundity matrices contain negative elements, and if
any matrices include NA values.
}
\description{
A function to simplify the viewing of basic information describing the
bootstrapped matrices produced through functions \code{\link{flefko3}()},
\code{\link{flefko2}()}, \code{\link{rlefko3}()}, \code{\link{rlefko2}()},
\code{\link{aflefko2}()}, \code{\link{rleslie}()}, and
\code{\link{fleslie}()} when using bootstrapped data input in format
\code{hfvlist}.
}
\section{Notes}{

Under the Gaussian and gamma size distributions, the number of estimated
parameters may differ between the two \code{ipm_method} settings. Because
the midpoint method has a tendency to incorporate upward bias in the
estimation of size transition probabilities, it is more likely to yield non-
zero values when the true probability is extremely close to 0. This will
result in the \code{summary.lefkoMat} function yielding higher numbers of
estimated parameters than the \code{ipm_method = "CDF"} yields in some cases.
}

\examples{
data(cypdata)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

cypraw_v1_boot <- bootstrap3(cypraw_v1, reps = 3)

# Here we use supplemental() to provide overwrite and reproductive info
cypsupp2r <- supplemental(stage3 = c("SD", "P1", "P2", "P3", "SL", "D", 
    "XSm", "Sm", "SD", "P1"),
  stage2 = c("SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "rep",
    "rep"),
  eststage3 = c(NA, NA, NA, NA, NA, "D", "XSm", "Sm", NA, NA),
  eststage2 = c(NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", NA, NA),
  givenrate = c(0.10, 0.20, 0.20, 0.20, 0.25, NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, 0.5, 0.5),
  type =c(1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
  stageframe = cypframe_raw, historical = FALSE)

cypmatrix2r_boot <- rlefko2(data = cypraw_v1_boot, stageframe = cypframe_raw, 
  year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added"), supplement = cypsupp2r,
  yearcol = "year2", patchcol = "patchid", indivcol = "individ")

summary(cypmatrix2r_boot)

}
