% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{sensitivity3.matrix}
\alias{sensitivity3.matrix}
\title{Estimate Sensitivity of Population Growth Rate of a Single Matrix}
\usage{
\method{sensitivity3}{matrix}(mats, sparse = "auto", ...)
}
\arguments{
\item{mats}{An object of class \code{matrix}.}

\item{sparse}{A text string indicating whether to use sparse matrix encoding
(\code{"yes"}) or dense matrix encoding (\code{"no"}). Defaults to
\code{"auto"}, in which case sparse matrix encoding is used with square
matrices with at least 50 rows and no more than 50\% of elements with values
greater than zero.}

\item{...}{Other parameters.}
}
\value{
This function returns a single deterministic sensitivity matrix.
}
\description{
\code{sensitivity3.matrix()} returns the sensitivities of \eqn{\lambda} to
elements of a single matrix. Because this handles only one matrix, the
sensitivities are inherently deterministic and based on the dominant eigen
value as the best metric of the population growth rate. This function can
handle large and sparse matrices, and so can be used with large historical
matrices, IPMs, age x stage matrices, as well as smaller ahistorical
matrices.
}
\section{Notes}{

All sensitivity matrix outputs from this function are in standard matrix
format.

Speed can sometimes be increased by shifting from automatic sparse matrix
determination to forced dense or sparse matrix projection. This will most
likely occur when matrices have between 30 and 300 rows and columns.
Defaults work best when matrices are very small and dense, or very large and
sparse.
}

\examples{
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframe, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, censor = TRUE)

lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sdl", "Sd", "Sdl", "mat"),
  stage2 = c("Sd", "Sd", "Sd", "Sd", "rep", "rep", "Sdl"),
  stage1 = c("Sd", "rep", "Sd", "rep", "npr", "npr", "Sd"),
  eststage3 = c(NA, NA, NA, NA, NA, NA, "mat"),
  eststage2 = c(NA, NA, NA, NA, NA, NA, "Sdl"),
  eststage1 = c(NA, NA, NA, NA, NA, NA, "NotAlive"),
  givenrate = c(0.345, 0.345, 0.054, 0.054, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, 0.345, 0.054, NA),
  type = c(1, 1, 1, 1, 3, 3, 1), type_t12 = c(1, 2, 1, 2, 1, 1, 1),
  stageframe = lathframe, historical = TRUE)

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe, year = "all", 
  stages = c("stage3", "stage2", "stage1"), supplement = lathsupp3,
  yearcol = "year2", indivcol = "individ")

ehrlen3mean <- lmean(ehrlen3)
sensitivity3(ehrlen3mean$A[[1]])

}
\seealso{
\code{\link{sensitivity3}()}

\code{\link{sensitivity3.lefkoMat}()}

\code{\link{sensitivity3.dgCMatrix}()}

\code{\link{sensitivity3.list}()}

\code{\link{sensitivity3.lefkoMatList}()}
}
