% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelselection.R
\name{parasearch}
\alias{parasearch}
\title{Develop Global Models and Datasets for Parallel Vital Rate Model Estimation}
\usage{
parasearch(
  data,
  historical = TRUE,
  approach = "mixed",
  suite = "size",
  vitalrates = c("surv", "size", "fec"),
  surv = c("alive3", "alive2", "alive1"),
  obs = c("obsstatus3", "obsstatus2", "obsstatus1"),
  size = c("sizea3", "sizea2", "sizea1"),
  repst = c("repstatus3", "repstatus2", "repstatus1"),
  fec = c("feca3", "feca2", "feca1"),
  stage = c("stage3", "stage2", "stage1"),
  indiv = "individ",
  patch = NA,
  year = "year2",
  sizedist = "gaussian",
  fecdist = "gaussian",
  size.zero = FALSE,
  fec.zero = FALSE,
  patch.as.random = TRUE,
  year.as.random = TRUE,
  juvestimate = NA,
  juvsize = FALSE,
  fectime = 2,
  censor = NA,
  age = NA,
  indcova = NA,
  indcovb = NA,
  indcovc = NA,
  quiet = FALSE
)
}
\arguments{
\item{data}{The vertical dataset to be used for analysis. This dataset should 
be of class \code{hfvdata}, but can also be a data frame formatted similarly
to the output format provided by functions \code{\link{verticalize3}()} or
\code{\link{historicalize3}()}, as long as all needed variables are properly
designated.}

\item{historical}{A logical variable denoting whether to assess the effects
of state in time \emph{t}-1 in addition to state in time \emph{t}. Defaults
to TRUE.}

\item{approach}{The statistical approach to be taken for model building. The 
default is \code{mixed}, which uses the mixed model approach utilized in 
packages \code{lme4} and \code{glmmTMB}. Other options include \code{glm},
which uses \code{lm}, \code{glm}, \code{glm.nb}, and related functions in
packages \code{MASS}, \code{stats}, and \code{pscl}.}

\item{suite}{This describes the global model for each vital rate estimation
and has the following possible values: \code{full}, includes main effects and
all two-way interactions of size and reproductive status; \code{main},
includes main effects only of size and reproductive status; \code{size},
includes only size (also interactions between size in historical model);
\code{rep}, includes only reproductive status (also interactions between
status in historical model); \code{cons}, all vital rates estimated only as
y-intercepts. If \code{approach = "glm"} and \code{year.as.random = FALSE},
then year is also included as a fixed effect, and, in the case of
\code{full}, included in two-way interactions. Defaults to \code{size}.}

\item{vitalrates}{A vector describing which vital rates will be estimated via
linear modeling, with the following options: \code{surv}, survival
probability; \code{obs}, observation probability; \code{size}, overall size;
\code{repst}, probability of reproducing; and \code{fec}, amount of
reproduction (overall fecundity). Defaults to \code{c("surv", "size", "fec")}.}

\item{surv}{A vector indicating the variable names coding for status as alive
or dead in times \emph{t}+1, \emph{t}, and \emph{t}-1, respectively. Defaults
to \code{c("alive3", "alive2", "alive1")}.}

\item{obs}{A vector indicating the variable names coding for observation
status in times \emph{t}+1, \emph{t}, and \emph{t}-1, respectively. Defaults
to \code{c("obsstatus3", "obsstatus2", "obsstatus1")}.}

\item{size}{A vector indicating the variable names coding for size in times
\emph{t}+1, \emph{t}, and \emph{t}-1, respectively. Defaults to
\code{c("sizea3", "sizea2", "sizea1")}.}

\item{repst}{A vector indicating the variable names coding for reproductive
status in times \emph{t}+1, \emph{t}, and \emph{t}-1, respectively. Defaults
to \code{c("repstatus3", "repstatus2", "repstatus1")}.}

\item{fec}{A vector indicating the variable names coding for fecundity in
times \emph{t}+1, \emph{t}, and \emph{t}-1, respectively. Defaults to
\code{c("feca3", "feca2", "feca1")}.}

\item{stage}{A vector indicating the variables coding for stage in times
\emph{t}+1, \emph{t}, and \emph{t}-1. Defaults to \code{c("stage3", "stage2",
"stage1")}.}

\item{indiv}{A variable indicating the variable name coding individual
identity. Defaults to \code{individ}.}

\item{patch}{A variable indicating the variable name coding for patch, where
patches are defined as permanent subgroups within the study population.
Defaults to NA.}

\item{year}{A variable indicating the variable coding for observation time in 
time \emph{t}. Defaults to \code{year2}.}

\item{sizedist}{The probability distribution used to model size. Options
include \code{gaussian} for the Normal distribution (default), \code{poisson}
for the Poisson distribution, and \code{negbin} for the negative binomial
distribution.}

\item{fecdist}{The probability distribution used to model fecundity. Options
include \code{gaussian} for the Normal distribution (default), \code{poisson}
for the Poisson distribution, and \code{negbin} for the negative binomial
distribution.}

\item{size.zero}{A logical variable indicating whether size distribution 
should be zero-inflated. Only applies to Poisson and negative binomial 
distributions. Defaults to FALSE.}

\item{fec.zero}{A logical variable indicating whether fecundity distribution 
should be zero-inflated. Only applies to Poisson and negative binomial 
distributions. Defaults to FALSE.}

\item{patch.as.random}{If set to TRUE and \code{approach = "lme4"}, then
\code{patch} is included as a random factor. If set to FALSE and
\code{approach = "glm"}, then \code{patch} is included as a fixed factor. All
other combinations of logical value and \code{approach} lead to \code{patch}
not being included in modeling. Defaults to TRUE.}

\item{year.as.random}{If set to TRUE and \code{approach = "lme4"}, then
\code{year} is included as a random factor. If set to FALSE, then \code{year}
is included as a fixed factor. All other combinations of logical value and
\code{approach} lead to \code{year} not being included in modeling. Defaults
to TRUE.}

\item{juvestimate}{An optional variable denoting the stage name of the
juvenile stage in the vertical dataset. If not NA, and \code{stage} is also
given (see below), then vital rates listed in \code{vitalrates} other than
\code{fec} will also be estimated from the juvenile stage to all adult
stages. Defaults to NA, in which case juvenile vital rates are not estimated.}

\item{juvsize}{A logical variable denoting whether size should be used as a
term in models involving transition from the juvenile stage. Defaults to
FALSE, and is only used if \code{juvestimate} does not equal NA.}

\item{fectime}{A variable indicating which year of fecundity to use as the
response term in fecundity models. Options include \code{2}, which refers to
time \emph{t}, and \code{3}, which refers to time \emph{t}+1. Defaults to
\code{2}.}

\item{censor}{A vector denoting the names of censoring variables in the
dataset, in order from time \emph{t}+1, followed by time \emph{t}, and lastly
followed by time \emph{t}-1. Defaults to NA.}

\item{age}{Designates the name of the variable corresponding to age in the
vertical dataset. Defaults to NA, in which case age is not included in linear
models. Should only be used if building age x stage matrices.}

\item{indcova}{Vector designating the names in times \emph{t}+1, \emph{t},
and \emph{t}-1 of an individual covariate. Defaults to NA.}

\item{indcovb}{Vector designating the names in times \emph{t}+1, \emph{t},
and \emph{t}-1 of an individual covariate. Defaults to NA.}

\item{indcovc}{Vector designating the names in times \emph{t}+1, \emph{t},
and \emph{t}-1 of an individual covariate. Defaults to NA.}

\item{quiet}{If set to TRUE, then model building and selection will proceed
without warnings and diagnostic messages being issued. Note that this will
not affect warnings and messages generated as models themselves are tested.
Defaults to FALSE.}
}
\value{
This function yields a list composed of the following elements:

\item{survival_global}{Global model of the binomial probability of survival
from time \emph{t} to time \emph{t}+1. Defaults to 1.}
\item{observation_global}{Global model of the binomial probability of 
observation in time \emph{t}+1 given survival to that time. Defaults to 1.}
\item{size_global}{Global model of size in time \emph{t}+1 given survival to
and observation in that time. Defaults to 1.}
\item{repstatus_global}{Global model of the binomial probability of
reproduction in time \emph{t}+1, given survival to and observation in that
time. Defaults to 1.}
\item{fecundity_global}{Global model of fecundity in time \emph{t}+1 given 
survival to, and observation and reproduction in that time. Defaults to 1.}
\item{juv_survival_global}{Global model of the binomial probability of
survival from time \emph{t} to time \emph{t}+1 of an immature individual.
Defaults to 1.}
\item{juv_observation_global}{Global model of the binomial probability of 
observation in time \emph{t}+1 given survival to that time of an immature
individual. Defaults to 1.}
\item{juv_size_global}{Global model of size in time \emph{t}+1 given
survival to and observation in that time of an immature individual. Defaults
to 1.}
\item{juv_reproduction_global}{Global model of the binomial probability of
reproduction in time \emph{t}+1, given survival to and observation in that
time of an individual that was immature in time \emph{t}. This model is
technically not a model of reproduction probability for individuals that are
immature, rather reproduction probability here is given for individuals that
are mature in time \emph{t}+1 but immature in time \emph{t}. Defaults to 1.}
\item{survival_data}{Subset of \code{data} used for survival estimation.}
\item{observation_data}{Subset of \code{data} used for observation
probability estimation.}
\item{size_data}{Subset of \code{data} used for size estimation.}
\item{repstatus_data}{Subset of \code{data} used for reproduction
probability.}
\item{fecundity_data}{Subset of \code{data} used for fecundity estimation.}
\item{juv_survival_data}{Subset of \code{data} used for immature survival 
probability estimation.}
\item{juv_observation_data}{Subset of \code{data} used for immature
observation probability estimation.}
\item{juv_size_data}{Subset of \code{data} used for immature size
estimation.}
\item{juv_reproduction_data}{Subset of \code{data} used for immature
reproduction probability estimation.}
\item{skeleton}{A skeleton \code{lefkoMod} object with \code{paramnames} and
\code{qc} filled in.}
}
\description{
Function \code{parasearch()} returns all requested global models and
associated datasets that would normally be produced while a run of function
\code{\link{modelsearch}()}, plus a skeleton \code{lefkoMod} object. These
outputs can then be used in combination with user-supplied
\code{\link[MuMIn]{pdredge}()} statements to create \code{lefkoMod} objects
that would otherwise take too long to estimate using standard single-thread
computing.
}
\section{Notes}{

The mechanics governing model building are fairly robust to errors and
exceptions. The function attempts to build global models, and simplifies
models automatically should model building fail. Model building proceeds
through the functions \code{\link[stats]{lm}()} (GLM with Gaussian response),
\code{\link[stats]{glm}()} (GLM with Poisson or binomial response),
\code{\link[MASS]{glm.nb}()} (GLM with negative binomial response),
\code{\link[pscl]{zeroinfl}()} (zero-inflated Poisson or negative binomial
response), \code{\link[lme4]{lmer}()} (mixed model with Gaussian response),
\code{\link[lme4]{glmer}()} (mixed model with binomial or Poisson response),
\code{\link[glmmTMB]{glmmTMB}()} (mixed model with negative binomial,
zero-inflated negative binomial, or zero-inflated Poisson response).
See documentation related to these functions for further information.

Once global models are built, the user should write parallelization code
to find the best-fit models in each case, and can substitute the appropriate
portions of object \code{skeleton} with outputs from these model building
and selection exercises.

Care must be taken to build models that test the impacts of state in time
\emph{t}-1 for historical models, and that do not test these impacts for
ahistorical models. Ahistorical matrix modeling particularly will yield
biased transition estimates if historical terms from models are ignored. This
can be dealt with at the start of modeling by setting 
\code{historical = FALSE} for the ahistorical case, and 
\code{historical = TRUE} for the historical case.
}

\examples{
\donttest{
data(lathyrus)

sizevector <- c(0, 4.6, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8,
  9)
stagevector <- c("Sd", "Sdl", "Dorm", "Sz1nr", "Sz2nr", "Sz3nr", "Sz4nr", 
  "Sz5nr", "Sz6nr", "Sz7nr", "Sz8nr", "Sz9nr", "Sz1r", "Sz2r", "Sz3r",
  "Sz4r", "Sz5r", "Sz6r", "Sz7r", "Sz8r", "Sz9r")
repvector <- c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1)
obsvector <- c(0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0)
indataset <- c(0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 4.6, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5,
  0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5)

lathframeln <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvertln <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "lnVol88", repstracol = "FCODE88",
  fecacol = "Intactseed88", deadacol = "Intactseed88",
  nonobsacol = "Dormant1988", stageassign = lathframeln, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, NAas0 = TRUE, censor = TRUE)

lathvertln$feca2 <- round(lathvertln$feca2)
lathvertln$feca1 <- round(lathvertln$feca1)
lathvertln$feca3 <- round(lathvertln$feca3)

lathmodelsln2 <- parasearch(lathvertln, historical = FALSE,
  approach = "lme4", suite = "main",
  vitalrates = c("surv", "obs", "size", "repst", "fec"), juvestimate = "Sdl",
  sizedist = "gaussian", fecdist = "poisson", indiv = "individ",
  patch = "patchid", year = "year2", year.as.random = TRUE,
  patch.as.random = TRUE)

summary(lathmodelsln2)
}

}
