% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distance_cs.R
\name{create_distance_cs}
\alias{create_distance_cs}
\title{Create a Distance based cost surface}
\usage{
create_distance_cs(raster, neighbours = 16)
}
\arguments{
\item{raster}{\code{RasterLayer} (raster package).}

\item{neighbours}{\code{numeric} value. Number of neighbouring cells. See Huber and Church (1985) for methodological considerations when choosing number of neighbours. Expected numeric values are 4, 8, 16, 32, 48 or a matrix object. Default is numeric value 16}
}
\value{
\code{TransitionLayer} (gdistance package) numerically expressing the distance between neighbouring cells
}
\description{
Creates a cost surface based on the distance between neighbouring cells. Distance corrected for if neighbours value greater than 4 (diagonal distance greater than straight line distance). Distance units are derived from the maximum resolution of the supplied RasterLayer.
}
\examples{
r <- raster::raster(system.file('external/maungawhau.grd', package = 'gdistance'))
distance_cs <- create_distance_cs(r, neighbours = 16)
}
\author{
Joseph Lewis
}
