% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quiz.R
\name{quiz}
\alias{quiz}
\alias{question}
\alias{answer}
\title{Tutorial quiz questions}
\usage{
quiz(..., caption = "Quiz")

question(text, ..., type = c("auto", "single", "multiple"),
  correct = "Correct!", incorrect = "Incorrect.", allow_retry = FALSE,
  random_answer_order = FALSE)

answer(text, correct = FALSE, message = NULL)
}
\arguments{
\item{...}{One or more questions or answers}

\item{caption}{Optional quiz caption (defaults to "Quiz")}

\item{text}{Question or option text}

\item{type}{Type of quiz question. Typically this can be automatically determined
based on the provided answers Pass \code{"single"} to indicate that even though
multiple correct answers are specified that inputs which include only one correct
answer are still correct. Pass \code{"multiple"} to force the use of checkboxes
(as opposed to radio buttons) even though only once correct answer was provided.}

\item{correct}{For \code{question}, text to print for a correct answer (defaults 
to "Correct!"). For \code{answer}, a boolean indicating whether this answer is
correct.}

\item{incorrect}{Text to print for an incorrect answer (defaults to "Incorrect.")}

\item{allow_retry}{Allow retry for incorrect answers.}

\item{random_answer_order}{Display answers in a random order.}

\item{message}{Additional message to display along with correct/incorrect feedback.}
}
\description{
Add interative multiple choice quiz questions to a tutorial.
}
\examples{
\dontrun{
question("What number is the letter A in the alphabet?",
  answer("8"),
  answer("14"),
  answer("1", correct = TRUE),
  answer("23")
)

question("Where are you right now? (select ALL that apply)",
  answer("Planet Earth", correct = TRUE),
  answer("Pluto"),
  answer("At a computing device", correct = TRUE),
  answer("In the Milky Way", correct = TRUE),
  incorrect = paste0("Incorrect. You're on Earth, ",
                     "in the Milky Way, at a computer.")
)
}

}
