% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDS_GA.R
\name{LDS_GA}
\alias{LDS_GA}
\title{Learn a linear dynamical system using Genetic Algorithm.}
\usage{
LDS_GA(
  y,
  u,
  v,
  lambda = 1,
  ub,
  lb,
  num.islands = 4,
  pop.per.island = 100,
  niter = 1000,
  parallel = TRUE
)
}
\arguments{
\item{y}{Transformed and standardized streamflow}

\item{u}{Input matrix for a single-model reconstruction, or a list of input matrices for an ensemble reconstruction.}

\item{v}{Same as u.}

\item{lambda}{weight for penalty}

\item{ub}{Upper bounds, a vector whose length is the number of parameters}

\item{lb}{Lower bounds}

\item{num.islands}{Number of islands (if method is GA; experimental)}

\item{pop.per.island}{Initial population per island (if method is GA; experimental)}

\item{niter}{Maximum number of iterations, default 1000}

\item{parallel}{Logical, whether parallel computation is used}
}
\value{
A list of reconstruction results; see \link{LDS_reconstruction}
}
\description{
\strong{Warning} This is an experimental feature. Use with care.
}
