% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_lcsm_lavaan_syntax.R
\name{specify_bi_lcsm}
\alias{specify_bi_lcsm}
\title{Specify lavaan model for bivariate latent change score models}
\usage{
specify_bi_lcsm(
  timepoints,
  var_x,
  model_x,
  var_y,
  model_y,
  coupling,
  add = NULL,
  change_letter_x = "g",
  change_letter_y = "j"
)
}
\arguments{
\item{timepoints}{Number of timepoints.}

\item{var_x}{Vector, specifying variables measuring one construct of the model.}

\item{model_x}{List, specifying model specifications (logical) for variables specified in \code{var_x}.
\itemize{
\item{\code{alpha_constant}}{ (Constant change factor)},
\item{\code{alpha_piecewise}}{ (Piecewise constant change factors)},
\item{\code{alpha_piecewise_num}}{ (Changepoint of piecewise constant change factors)},
\item{\code{alpha_linear}}{ (Linear change factor)},
\item{\code{beta}}{ (Proportional change factor)},
\item{\code{phi}}{ (Autoregression of change scores)}.
}}

\item{var_y}{Vector, specifying variables measuring another construct of the model.}

\item{model_y}{List, specifying model specifications (logical) for variables specified in \code{var_y}.
\itemize{
\item{\code{alpha_constant}}{ (Constant change factor)},
\item{\code{alpha_piecewise}}{ (Piecewise constant change factors)},
\item{\code{alpha_piecewise_num}}{ (Changepoint of piecewise constant change factors)},
\item{\code{alpha_linear}}{ (Linear change factor)},
\item{\code{beta}}{ (Proportional change factor)},
\item{\code{phi}}{ (Autoregression of change scores)}.
}}

\item{coupling}{List, specifying coupling parameters.
\itemize{
\item{\code{coupling_piecewise}}{ (Piecewise coupling parameters)},
\item{\code{coupling_piecewise_num}}{ (Changepoint of piecewise coupling parameters)},
\item{\code{delta_con_xy}}{ (True score y predicting concurrent change score x)},
\item{\code{delta_lag_xy}}{ (True score y predicting subsequent change score x)},
\item{\code{delta_con_yx}}{ (True score x predicting concurrent change score y)},
\item{\code{delta_lag_yx}}{ (True score x predicting subsequent change score y)},
\item{\code{xi_con_xy}}{ (Change score y predicting concurrent change score x)},
\item{\code{xi_lag_xy}}{ (Change score y predicting subsequent change score x)},
\item{\code{xi_con_yx}}{ (Change score x predicting concurrent change score y)},
\item{\code{xi_lag_yx}}{ (Change score x predicting subsequent change score y)}.
}}

\item{add}{String, lavaan syntax to be added to the model}

\item{change_letter_x}{String, specifying letter to be used as change factor for construct x in lavaan syntax.}

\item{change_letter_y}{String, specifying letter to be used as change factor for construct y in lavaan syntax.}
}
\value{
Lavaan model syntax including comments.
}
\description{
Specify lavaan model for bivariate latent change score models
}
\examples{
# Specify bivariate LCSM
lavaan_bi_lcsm_01 <- specify_bi_lcsm(timepoints = 10, 
                                     var_x = "x",
                                     model_x = list(alpha_constant = TRUE, 
                                                    beta = TRUE, 
                                                    phi = TRUE),
                                     var_y = "y",  
                                     model_y = list(alpha_constant = TRUE, 
                                                    beta = TRUE, 
                                                    phi = TRUE),  
                                     coupling = list(delta_lag_xy = TRUE, 
                                                     delta_lag_yx = TRUE),
                                     change_letter_x = "g",
                                     change_letter_y = "j")

# To look at string simply return the object                                    
lavaan_bi_lcsm_01

# To get a readable output use cat() function
cat(lavaan_bi_lcsm_01)

}
\references{
Ghisletta, P., & McArdle, J. J. (2012). Latent Curve Models and Latent Change Score Models Estimated in R. Structural Equation Modeling: A Multidisciplinary Journal, 19(4), 651–682. \doi{doi.org/10.1080/10705511.2012.713275}.

Grimm, K. J., Ram, N., & Estabrook, R. (2017). Growth Modeling—Structural Equation and Multilevel Modeling Approaches. New York: The Guilford Press.

McArdle, J. J. (2009). Latent variable modeling of differences and changes with longitudinal data. Annual Review of Psychology, 60(1), 577–605. \doi{10.1146/annurev.psych.60.110707.163612}.

Yves Rosseel (2012). lavaan: An R Package for Structural Equation Modeling. Journal of Statistical Software, 48(2), 1-36.
\doi{10.18637/jss.v048.i02}.
}
