% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/liouville.R
\name{pliouv.opt}
\alias{pliouv.opt}
\title{Internal code for the copula likelihood function for Liouville copulas}
\usage{
pliouv.opt(theta, data, family, alphavec, MC.approx = T)
}
\arguments{
\item{theta}{parameter of the corresponding Archimedean copula}

\item{data}{sample matrix from a Liouville copula}

\item{family}{family of the Liouville copula. Either \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"AMH"} or \code{"joe"}}

\item{alphavec}{vector of Dirichlet allocations (must be a vector of integers)}

\item{MC.approx}{whether to use Monte-Carlo approximation for the inverse survival function (default is \code{TRUE})}
}
\value{
value of marginal density
}
\description{
The function is used internally for optimization.
}

