% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/liouville.R
\name{H_inv}
\alias{H_inv}
\title{Inverse survival function if Monte-Carlo approximation is set to \code{TRUE} in \code{liouv.maxim}}
\usage{
H_inv(u, alphavec, family, theta, MC = 1e+05, TRUNC = F)
}
\arguments{
\item{u}{data at which to compute the survival inverse}

\item{alphavec}{vector of Dirichlet allocations (must be a vector of integers)}

\item{family}{family of the Liouville copula. Either \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"AMH"} or \code{"joe"}}

\item{theta}{parameter of the corresponding Archimedean copula}

\item{MC}{number of Monte-Carlo points for evaluation}

\item{trunc}{whether to truncate at low quantile. Will be based on numerical root finding for the lower 0.025 fraction of the data}
}
\value{
Inverse survival function values
}
\description{
The function is used internally for optimization.
}
\examples{
u <- rliouv(n = 100, family = "frank", alphavec <- c(2,3), theta = 1)
H_inv(u=u, family="frank", alphavec=c(2,3), theta=2)
#Difference between true value and approximation (can be large depending on family)
sum(abs(H_inv(u=u, family="frank", alphavec=c(2,3), theta=2)-
isliouvm_m(u=u, family="frank", alphavec=c(2,3), theta=2)))
}
\keyword{internal}

