% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt_create_graphs.R
\name{opt_create_graphs}
\alias{opt_create_graphs}
\title{Function to create summary graphs of the trading results}
\usage{
opt_create_graphs(x, outp_path, graph_type = "pdf")
}
\arguments{
\item{x}{\itemize{
\item dataframe with aggregated trading results
}}

\item{outp_path}{\itemize{
\item path to the folder where to write file
}}

\item{graph_type}{\itemize{
\item character, one of the options c('ts', 'bars', 'pdf')
}}
}
\value{
graphic output
}
\description{
Create graphs and store them into pdf file

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\details{
bar graph and time series optionally written to the pdf file.
File is named with a date of analysis to the location specified by the user
}
\examples{

 library(lazytrade)
 library(readr)
 library(dplyr)
 library(magrittr)
 library(lubridate)
 library(ggplot2)
 data(DFR)
 dir <- normalizePath(tempdir(),winslash = "/")
 # create pdf file with two graphs
 opt_create_graphs(x = DFR, outp_path = dir)

 # only show time series plot
 opt_create_graphs(x = DFR, graph_type = 'ts')


}
