% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aml_consolidate_results.R
\name{aml_consolidate_results}
\alias{aml_consolidate_results}
\title{Function to consolidate model test results}
\usage{
aml_consolidate_results(
  timeframe = 15,
  used_symbols,
  path_model,
  path_sbxm,
  path_sbxs,
  min_quality = 0.75,
  get_quantile = FALSE,
  log_results = FALSE,
  path_logs = NULL
)
}
\arguments{
\item{timeframe}{Integer, Data timeframe interval in minutes e.g. 60 min}

\item{used_symbols}{Vector, containing several financial instruments that were previously used
to test the model}

\item{path_model}{String, User path where the test results were stored}

\item{path_sbxm}{String, User path to the sandbox where file with strategy test results should be written (master terminal)}

\item{path_sbxs}{String, User path to the sandbox where file with strategy test results should be written (slave terminal)}

\item{min_quality}{Double, value typically from 0.25 to 0.95 to select the min threshold value}

\item{get_quantile}{Bool, whether or not function should return an overall value of model performances
this will be used to conditionally update only less performant models}

\item{log_results}{Bool, option to write logs with cumulative results obtained for all models}

\item{path_logs}{String, User path to the folder where to log results}
}
\value{
Function is writing files into Decision Support System folders
}
\description{
Function is designed to evaluate test results of multiple models.
This is done to select only group of models with the best performance. In addition,
function will provide facility to generate logs hence to allow tracking of long term model performance

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
Provide a modular facility to aggregate and update files, write performance logs.
}
\examples{


library(dplyr)
library(magrittr)
library(readr)
library(lazytrade)
library(stats)

testpath <- normalizePath(tempdir(),winslash = "/")
path_model <- file.path(testpath, "_Model")
path_sbxm <- file.path(testpath, "_T1")
path_sbxs <- file.path(testpath, "_T3")
path_logs <- file.path(testpath, "_LOGS")
dir.create(path_model)
dir.create(path_sbxm)
dir.create(path_sbxs)
dir.create(path_logs)

file.copy(from = system.file("extdata", "StrTest-EURGBPM15.csv", package = "lazytrade"),
          to = file.path(path_model, "StrTest-EURGBPM15.csv"), overwrite = TRUE)

file.copy(from = system.file("extdata", "StrTest-EURJPYM15.csv", package = "lazytrade"),
          to = file.path(path_model, "StrTest-EURJPYM15.csv"), overwrite = TRUE)

file.copy(from = system.file("extdata", "StrTest-EURNZDM15.csv", package = "lazytrade"),
          to = file.path(path_model, "StrTest-EURNZDM15.csv"), overwrite = TRUE)

file.copy(from = system.file("extdata", "StrTest-EURUSDM15.csv", package = "lazytrade"),
          to = file.path(path_model, "StrTest-EURUSDM15.csv"), overwrite = TRUE)

Pairs <- c("EURGBP","EURJPY","EURNZD","EURUSD")

aml_consolidate_results(timeframe = 15,
                        used_symbols = Pairs,
                        path_model = path_model,
                        path_sbxm = path_sbxm,
                        path_sbxs = path_sbxs,
                        min_quality = 0.75,
                        get_quantile = FALSE)


aml_consolidate_results(timeframe = 15,
                        used_symbols = Pairs,
                        path_model = path_model,
                        path_sbxm = path_sbxm,
                        path_sbxs = path_sbxs,
                        min_quality = 0.75,
                        get_quantile = TRUE)


aml_consolidate_results(timeframe = 15,
                        used_symbols = Pairs,
                        path_model = path_model,
                        path_sbxm = path_sbxm,
                        path_sbxs = path_sbxs,
                        min_quality = 0.75,
                        get_quantile = FALSE,
                        log_results = TRUE,
                        path_logs = path_logs)


}
\author{
(C) 2021 Vladimir Zhbanko
}
