% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runs.test.R
\name{runs.test}
\alias{runs.test}
\title{Runs Test for Randomness}
\usage{
runs.test(y, plot.it = FALSE, alternative = c("two.sided",
  "positive.correlated", "negative.correlated"))
}
\arguments{
\item{y}{a numeric vector of data values.}

\item{plot.it}{logical. If \code{TRUE}, then the graph will be plotted. 
If \code{FALSE} (default), then it is not plotted.}

\item{alternative}{a character string specifying the alternative hypothesis, 
must be one of \code{"two.sided"} (default), \code{"negative.correlated"}, 
or \code{"positive.correlated"}.}
}
\value{
A list of class \code{"htest"} with the following components:
\item{statistic}{the value of the standardized runs statistic.}
\item{p.value}{the \eqn{p}-value for the test.}
\item{data.name}{a character string giving the names of the data.}
\item{alternative}{a character string describing the alternative hypothesis.}
}
\description{
Performs the runs test for randomness \insertCite{Mendenhall_Reinmuth_1982}{lawstat}. 
Users can choose whether to plot the 
correlation graph or not, and whether to test against two-sided, negative, 
or positive correlation. \code{NA}s from the data are omitted.
}
\details{
On the graph, observations that are less than the sample median are 
represented by red letters "A", and observations that are greater or equal to the 
sample median are represented by blue letters "B".
}
\examples{
##Simulate 100 observations from an autoregressive model 
## of the first order (AR(1))
y = arima.sim(n = 100, list(ar = c(0.5)))

##Test y for randomness
runs.test(y)


}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{bartels.test}}
}
\author{
Wallace Hui, Yulia R. Gel, Joseph L. Gastwirth, Weiwen Miao
}
\keyword{distribution}
\keyword{htest}
