% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initVarlink.R
\name{initVarLink}
\alias{initVarLink}
\alias{initVarLinks}
\title{Normalize var1 and var2}
\usage{
initVarLink(var1, var2, rep.var1 = FALSE, format = "list",
  Slink = c(lava.options()$symbols[1], "~"),
  Scov = lava.options()$symbols[2])

initVarLinks(var1, format = "list", ...)
}
\arguments{
\item{var1}{[character or formula] the exogenous variable of the new link or a formula describing the link.}

\item{var2}{[character] the endogenous variable of the new link.
Disregarded if the argument \code{var1} is a formula.}

\item{rep.var1}{[logical] should var1 be duplicated to match var2 length.
Only active if \code{format = "list"}.}

\item{format}{[character] should the name of the variable be returned (\code{format = "list"}),
a vector of character formula (\code{format = "txt.formula"}),
or a list of formula (\code{format = "formula"}).}

\item{Slink}{[character] the symbol for regression link.}

\item{Scov}{[character] the symbol for covariance link.}

\item{...}{argument to be passed to \code{initVarLink}.}
}
\value{
See argument \code{format}.
}
\description{
Convert var1 and var2 from formula or covariance to character.
}
\examples{
initVarLink(y ~ x1)
initVarLink("y ~ x1")
initVarLink(y ~ x1 + x2)
initVarLink("y ~ x1 + x2")
initVarLink(y ~ x1 + x2, rep.var1 = TRUE)
initVarLink(y ~ x1 + x2, rep.var1 = TRUE, format = "formula")
initVarLink(y ~ x1 + x2, rep.var1 = TRUE, format = "txt.formula")
initVarLink("y", "x1", format = "formula")

initVarLink("y ~ x1:0|1")

initVarLinks(y ~ x1)
initVarLinks("y ~ x1")
initVarLinks(c("y ~ x1","y~ x2"))
initVarLinks(c(y ~ x1,y ~ x2))
initVarLinks(c("y ~ x1","y ~ x2"), format = "formula")
initVarLinks(c(y ~ x1,y ~ x2), format = "formula")
initVarLinks(c("y ~ x1","y~ x2"), format = "txt.formula")
initVarLinks(c(y ~ x1,y ~ x2), format = "txt.formula")
}
