% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Missing.R
\name{Missing}
\alias{Missing}
\alias{Missing,}
\alias{Missing<-}
\title{Missing value generator}
\usage{
Missing(object, formula, Rformula, missing.name, suffix = "0", ...)
}
\arguments{
\item{object}{\code{lvm}-object.}

\item{formula}{The right hand side specifies the name of a latent
variable which is not always observed. The left hand side
specifies the name of a new variable which is equal to the latent
variable but has missing values.  If given as a string then this
is used as the name of the latent (full-data) name, and the
observed data name is 'missing.data'}

\item{Rformula}{Missing data mechanism with left hand side
specifying the name of the observed data indicator (may also just
be given as a character instead of a formula)}

\item{missing.name}{Name of observed data variable (only used if
'formula' was given as a character specifying the name of the
full-data variable)}

\item{suffix}{If missing.name is missing, then the name of the
oberved data variable will be the name of the full-data variable +
the suffix}

\item{...}{Passed to binomial.lvm.}
}
\value{
lvm object
}
\description{
Missing value generator
}
\details{
This function adds a binary variable to a given \code{lvm} model
and also a variable which is equal to the original variable where
the binary variable is equal to zero
}
\examples{
library(lava)
set.seed(17)
m <- lvm(y0~x01+x02+x03)
m <- Missing(m,formula=x1~x01,Rformula=R1~0.3*x02+-0.7*x01,p=0.4)
sim(m,10)


m <- lvm(y~1)
m <- Missing(m,"y","r")
## same as
## m <- Missing(m,y~1,r~1)
sim(m,10)

## same as
m <- lvm(y~1)
Missing(m,"y") <- r~x
sim(m,10)

m <- lvm(y~1)
m <- Missing(m,"y","r",suffix=".")
## same as
## m <- Missing(m,"y","r",missing.name="y.")
## same as
## m <- Missing(m,y.~y,"r")
sim(m,10)
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}

