% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.lass0}
\alias{predict.lass0}
\title{Predict method for a Lasso-Zero fit}
\usage{
\method{predict}{lass0}(object, Xnew, ...)
}
\arguments{
\item{object}{a \code{"lass0"} object}

\item{Xnew}{a new input matrix whose number of columns equals the number of coefficients returned in \code{obj}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
vector of predictions
}
\description{
Predicted values for the response given a new input matrix Xnew, based on a \code{lass0} fit.
}
\references{
Descloux, P., & Sardy, S. (2018). Model selection with
  lasso-zero: adding straw to the haystack to better find needles. arXiv
  preprint arXiv:1805.05133. \url{https://arxiv.org/abs/1805.05133}
}
\seealso{
\code{\link{lass0}}
}
