% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{setOutputs}
\alias{setOutputs}
\title{Set outputs}
\usage{
setOutputs(params, output_list)
}
\arguments{
\item{params}{a LandsepiParams object.}

\item{output_list}{a list of outputs to be generated and parameters for output generation.
It can be generated manually or, alternatively, via \code{\link{loadOutputs}}. This list
is composed of:\itemize{
\item epid_outputs = epidemiological outputs to compute (see details)
\item evol_outputs = evolutionary outputs to compute (see details)
\item thres_breakdown = an integer (or vector of integers) giving the threshold
(i.e. number of infections) above which a pathogen genotype is unlikely to go extinct,
used to characterise the time to invasion of resistant hosts (several values are computed
if several thresholds are given in a vector).
\item audpc100S = the audpc in a fully susceptible landscape (used as reference value
for graphics).
}}
}
\value{
a LandsepiParams object.
}
\description{
Updates a LandsepiParams object with a list of output parameters.
}
\details{
"epid_outputs" is a character string (or a vector of character strings if several
outputs are to be computed) specifying the type of epidemiological and economic outputs
to generate:
\itemize{
\item "audpc" : Area Under Disease Progress Curve (average number of diseased host individuals
per time step and square meter)
\item "audpc_rel" : Relative Area Under Disease Progress Curve (average proportion of
diseased host individuals relative to the total number of existing hosts)
\item "gla" : Green Leaf Area (average number of healthy host individuals per square meter)
\item "gla_rel" : Relative Green Leaf Area (average proportion of healthy host individuals
relative to the total number of existing hosts)
\item "eco_yield" : total crop yield (in weight or volume units per ha)
\item "eco_cost" : operational crop costs (in monetary units per ha)
\item "eco_product" : total crop products (in monetary units per ha)
\item "eco_margin" : Margin (products - costs, in monetary units per ha)
\item "contrib": contribution of pathogen genotypes to LIR dynamics
\item "HLIR_dynamics", "H_dynamics", "L_dynamics", "IR_dynamics", "HLI_dynamics", etc.:
Epidemic dynamics related to the specified sanitary status (H, L, I or R and all their
combinations). Graphics only, works only if graphic=TRUE.
\item "all" : compute all these outputs (default)
\item "" : none of these outputs will be generated.
}
"evol_outputs" is a character string (or a vector of character strings if several outputs
are to be computed) specifying the type of evolutionary outputs to generate :\itemize{
\item "evol_patho": Dynamics of pathogen genotype frequencies
\item "evol_aggr": Evolution of pathogen aggressiveness
\item "durability": Durability of resistance genes
\item "all": compute all these outputs (default)
\item "": none of these outputs will be generated.
}
}
\examples{
\dontrun{
simul_params <- createSimulParams()
simul_params <- setOutputs(simul_params, loadOutputs())
simul_params@Outputs
}
}
\seealso{
\link{loadOutputs}
}
