% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_mutinf.R
\name{lsm_l_mutinf}
\alias{lsm_l_mutinf}
\title{MUTINF (landscape level)}
\usage{
lsm_l_mutinf(landscape, neighbourhood = 4, ordered = TRUE, base = "log2")
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{neighbourhood}{The number of directions in which cell adjacencies are considered as neighbours:
4 (rook's case) or 8 (queen's case). The default is 4.}

\item{ordered}{The type of pairs considered.
Either ordered (TRUE) or unordered (FALSE).
The default is TRUE.}

\item{base}{The unit in which entropy is measured.
The default is "log2", which compute entropy in "bits".
"log" and "log10" can be also used.}
}
\value{
tibble
}
\description{
Mutual information \[I(y,x)\]
}
\details{
It disambiguates landscape pattern types characterize by the same value of an
overall complexity (\code{\link{lsm_l_joinent}}).
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_l_mutinf(landscape)

}
\references{
Nowosad J., TF Stepinski. 2019. Information theory as a consistent framework
for quantification and classification of landscape patterns. https://doi.org/10.1007/s10980-019-00830-x
}
\seealso{
\code{\link{lsm_l_ent}},
\code{\link{lsm_l_condent}},
\code{\link{lsm_l_joinent}},
\code{\link{lsm_l_relmutinf}}
}
