% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_gyrate_mn.R
\name{lsm_c_gyrate_mn}
\alias{lsm_c_gyrate_mn}
\title{GYRATE_MN (class level)}
\usage{
lsm_c_gyrate_mn(landscape, directions = 8, cell_center = FALSE)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{cell_center}{If true, the coordinates of the centroid are forced to be
a cell center within the patch.}
}
\value{
tibble
}
\description{
Mean radius of gyration (Area and edge metric)
}
\details{
\deqn{GYRATE_{MN} = mean(GYRATE[patch_{ij}])}
where \eqn{GYRATE[patch_{ij}]} equals the radius of gyration of each patch.

GYRATE_MN is an 'Area and edge metric'. The metric summarises each class
as the mean of the radius of gyration of all patches belonging to class i.
GYRATE measures the distance from each cell to the patch centroid and is based on
cell center-to-cell center distances. The metrics characterises
both the patch area and compactness.

If \code{cell_center = TRUE} some patches might have several possible cell-center
centroids. In this case, the gyrate index is based on the mean distance of all
cells to all possible cell-center centroids.

Because the metric is based on distances or areas please make sure your data
is valid using \code{\link{check_landscape}}.

\subsection{Units}{Meters}
\subsection{Range}{GYRATE_MN >= 0 }
\subsection{Behaviour}{Approaches GYRATE_MN = 0 if every patch is a single cell. Increases,
without limit, when only one patch is present.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_c_gyrate_mn(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org

Keitt, T. H., Urban, D. L., & Milne, B. T. 1997. Detecting critical scales
in fragmented landscapes. Conservation ecology, 1(1).
}
\seealso{
\code{\link{lsm_p_gyrate}},
\code{\link[base]{mean}}, \cr
\code{\link{lsm_c_gyrate_sd}},
\code{\link{lsm_c_gyrate_cv}}, \cr
\code{\link{lsm_l_gyrate_mn}},
\code{\link{lsm_l_gyrate_sd}},
\code{\link{lsm_l_gyrate_cv}}
}
