% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_area_mn.R
\name{lsm_c_area_mn}
\alias{lsm_c_area_mn}
\title{AREA_MN (class level)}
\usage{
lsm_c_area_mn(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Mean of patch area (Area and edge metric)
}
\details{
\deqn{AREA_{MN} = mean(AREA[patch_{ij}])}
where \eqn{AREA[patch_{ij}]} is the area of each patch in hectares

AREA_MN is an 'Area and Edge metric'. The metric summarises each class
as the mean of all patch areas belonging to class i. The metric is a simple way
to describe the composition of the landscape. Especially together with the total
class area (\code{\link{lsm_c_ca}}), it can also give an an idea of patch structure
(e.g. many small patches vs. few larges patches).

Because the metric is based on distances or areas please make sure your data
is valid using \code{\link{check_landscape}}.

\subsection{Units}{Hectares}
\subsection{Range}{AREA_MN > 0}
\subsection{Behaviour}{Approaches AREA_MN = 0 if all patches are small. Increases, without
limit, as the patch areas increase.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_c_area_mn(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org
}
\seealso{
\code{\link{lsm_p_area}},
\code{\link[base]{mean}}, \cr
\code{\link{lsm_c_area_cv}},
\code{\link{lsm_c_area_sd}}, \cr
\code{\link{lsm_l_area_mn}},
\code{\link{lsm_l_area_sd}},
\code{\link{lsm_l_area_cv}}
}
