% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/certificate_attendance.R
\name{create_attendance_certificate}
\alias{create_attendance_certificate}
\title{Create certificate of attendance}
\usage{
create_attendance_certificate(
  data = NULL,
  path = NULL,
  filename = NULL,
  language = c("English", "Spanish"),
  name.column = NULL,
  type = "",
  title = "",
  date = "",
  hours = "",
  freetext = "",
  signer = "",
  signer.role = "",
  signature.pic = NULL,
  lpic = NULL,
  rpic = NULL,
  keep.files = FALSE,
  template = NULL
)
}
\arguments{
\item{data}{a data frame containing attendees' names (in \code{name.column})}

\item{path}{Character. Path to folder where the PDF certificates will be saved.}

\item{filename}{Character. Filename of the pdf. If NULL, default is "Attendance" for English, "Asistencia" for Spanish".}

\item{language}{Character. Select 'English' or 'Spanish'.}

\item{name.column}{Character. Name of the column in \code{data} storing attendees' name.}

\item{type}{Character (optional). Type of event (conference, workshop, seminar...)}

\item{title}{Character. Title of the event}

\item{date}{Date of the event}

\item{hours}{Number of hours the event has lasted}

\item{freetext}{Character (optional). Free text to insert between the
event title and date. Can include LaTeX commands (see examples).}

\item{signer}{Character. Person who signs the certificate}

\item{signer.role}{Character. Signer's role or position}

\item{signature.pic}{Character (optional). Path to a PNG image to appear in
the bottom, above signer's name.}

\item{lpic}{Character (optional). Path to a PNG image to appear in the top-left.}

\item{rpic}{Character (optional). Path to a PNG image to appear in the top-right.}

\item{keep.files}{Logical. Keep the RMarkdown template and associated files
in the output folder? Default is FALSE.}

\item{template}{Character (optional) RMarkdown template to use. If not provided,
using the default template included in \code{labeleR}.}
}
\value{
PDF certificates are saved on disk, in the folder defined
by \code{path}. If \code{keep.files = TRUE}, the RMarkdown template and PNG logo files
will also appear in the same folder.
}
\description{
Create certificate of attendance (1 certificate per DIN-A4 page)
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

create_attendance_certificate(
  data = attendance.table,
  path = "labeleR_output",
  language = "English",
  name.column = "Names",
  type = "class",
  title = "Potions Class",
  date = "01/01/2021",
  hours = 200,
  freetext = "organised by {\\\\bf Hogwarts School year 1992-1993}",
  signer = "A.P.W.B. Dumbledore",
  signer.role = "School Headmaster",
  lpic = NULL,
  rpic = NULL,
  signature.pic = NULL,
)
\dontshow{\}) # examplesIf}
}
\author{
Ignacio Ramos-Gutierrez, Julia G. de Aledo, Francisco Rodriguez-Sanchez
}
