% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_label.R
\name{set_label}
\alias{set_label}
\alias{set_label.default}
\alias{set_label.data.frame}
\title{Set the label of an atomic vector}
\source{
Frank E Harrell Jr, with contributions from Charles Dupont and many
others. (2017). Hmisc: Harrell Miscellaneous. R package version 4.0-3.
https://CRAN.R-project.org/package=Hmisc
}
\usage{
set_label(x, ...)

\method{set_label}{default}(x, label, ...)

\method{set_label}{data.frame}(x, ...)
}
\arguments{
\item{x}{An atomic vector}

\item{...}{For the default method, arguments to pass to other methods.
For the \code{data.frame} method, key-pairs of the pattern
\code{variable = 'label'}.}

\item{label}{\code{character(1)}, A character string denoting the label
to assign to the variable.}
}
\description{
Variable labels are a common construct in statistical
  software, giving users the ability to provide plain text descriptions
  for variables.  These descriptions can be more informative of the
  variable's purpose, since they need not be restricted to the naming
  conventions imposed on variable names.
}
\examples{
x <- 1:10
x <- set_label(x, "Integers")
x

# Set labels for variables in a data frame

mtcars2 <-
  set_label(mtcars,
            am = "Automatic / Manual",
            mpg = "Miles per Gallon",
            gear = "Number of gears")

get_label(mtcars2)

}
\seealso{
\code{\link{get_label}}
}
