% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l1_spectralclustering.R
\name{l1_spectralclustering}
\alias{l1_spectralclustering}
\title{Run the l1-spectral clustering algorithm}
\usage{
l1_spectralclustering(A, k = NULL, elements = NULL, pen, stab = TRUE)
}
\arguments{
\item{A}{The adjacency matrix of the graph to cluster.}

\item{k}{True number of clusters (not necessarily needed). If not provided, k is chosen by spectral eigengap.}

\item{elements}{The representative elements of the clusters (not necessary needed). If not provided, index are chosen using the betweeness centrality score.}

\item{pen}{The penalty (to be chosen among "lasso" or "thresholdedLS").}

\item{stab}{TRUE/FALSE indicated whether the indices should be stabilized (TRUE by default)}
}
\value{
A list with the following elements:
\itemize{
\item{\code{comm}}{ The community matrix,}
\item{\code{structure}}{ The structure of the graph to cluster,}
\item{\code{clusters}}{ The number of clusters,}
\item{\code{elements}}{ The chosen representative elements of the clusters.}
}
}
\description{
This function runs the l1-spectral algorithm, an l1-penalized version of the spectral clustering that aims at robustly clustering perturbed graphs.
}
\examples{
 #####################################################
 # Performing the l1-spectral clustering on the graph
 #####################################################

 data(ToyData)

 # if desired, the number of clusters and representative elements can be provided, otherwise, remove
 results2 <- l1_spectralclustering(A = ToyData$A_hat, pen = "lasso")
 results2$comm

 # when desired, the number of clusters and representative elements can also be provided
 \donttest{results2 <- l1_spectralclustering(A = ToyData$A_hat, pen = "lasso",
             k=2, elements = c(1,4))}
}
\seealso{
\code{\link{ComputePerformances}}, \code{\link{l1spectral}}.
}
\author{
Camille Champion, Magali Champion
}
