## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library(kstMatrix)
library(igraph)
library(grDevices)

## -----------------------------------------------------------------------------
kmbasis(xpl$space)

## -----------------------------------------------------------------------------
kmunionclosure(xpl$basis)

## -----------------------------------------------------------------------------
kmsurmiserelation(xpl$space)

## -----------------------------------------------------------------------------
kmunionclosure(t(kmsurmiserelation(xpl$space)))

## -----------------------------------------------------------------------------
kmiswellgraded(xpl$space)

## -----------------------------------------------------------------------------
x <- matrix(c(0,0,0, 1,0,0, 1,1,1), nrow = 3, byrow = TRUE)
kmnotions(x)

## -----------------------------------------------------------------------------
x <- matrix(c(0,0,0, 1,0,0, 1,1,1), nrow = 3, byrow = TRUE)
kmeqreduction(x)

## -----------------------------------------------------------------------------
kmminimalspace(5)

## -----------------------------------------------------------------------------
kmmaximalspace(4)

## -----------------------------------------------------------------------------
kmdist(xpl$data, xpl$space)

## -----------------------------------------------------------------------------
kmvalidate(xpl$data, xpl$space)

## -----------------------------------------------------------------------------
kmsimulate(xpl$space, 10, 0.2, 0.1)
kmsimulate(xpl$space, 10, c(0.2, 0.25, 0.15, 0.2), c(0.1, 0.15, 0.05, 0.1))
kmsimulate(xpl$space, 10, c(0.2, 0.25, 0.15, 0.2), 0)

## -----------------------------------------------------------------------------
kmneighbourhood(c(1,1,0,0), xpl$space)

## -----------------------------------------------------------------------------
kmfringe(c(1,0,0,0), xpl$space)

## -----------------------------------------------------------------------------
kmsymmsetdiff(c(1,0,0), c(1,1,0))

## -----------------------------------------------------------------------------
kmsetdistance(c(1,0,0), c(1,1,0))

## -----------------------------------------------------------------------------
probability_vec <- (0:8)/8
colorvec <- kmcolors(probability_vec, cm.colors)
kmhasse(xpl$space, horizontal = TRUE, colors = colorvec)

## -----------------------------------------------------------------------------
summary(cad)

## -----------------------------------------------------------------------------
summary(readwrite)

## -----------------------------------------------------------------------------
summary(fractions)

## -----------------------------------------------------------------------------
summary(xpl)
xpl$basis
xpl$space
xpl$data

