% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.krige}
\alias{summary.krige}
\title{Summarize Fitted Kriging Model}
\usage{
\method{summary}{krige}(object, ...)
}
\arguments{
\item{object}{An \code{krige} object from the \code{metropolis.krige} function.}

\item{\dots}{Additional arguments passed to \code{summary} methods. Not supported for 
\code{krige} object.}
}
\value{
A \code{summary.krige} list object.
}
\description{
Create a summary of a estimated model from \code{metropolis.krige}
}
\details{
The function creates a summary of the model estimated by \code{metropolis.krige}.
  The output includes both the parameters and estimates of the model.
}
\examples{
\dontrun{
# Summarize data
summary(ContrivedData)

# Initial OLS model
contrived.ols<-lm(y~x.1+x.2,data=ContrivedData)
# summary(contrived.ols)

# Set seed
set.seed(1241060320)

#For simple illustration, we set to few iterations.
#In this case, a 10,000-iteration run converges to the true parameters.
#If you have considerable time and hardware, delete the # on the next line.
#10,000 iterations took 39 min. with 8 GB RAM & a 1.5 GHz Quad-Core processor.
M <- 100
#M<-10000

contrived.run <- metropolis.krige(y ~ x.1 + x.2, coords = c("s.1","s.2"), 
   data = ContrivedData, n.iter = M, range.tol = 0.05)

# Summary
summary(contrived.run)
}

}
\seealso{
\code{\link{as.mcmc.summary.krige}}
}
