% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semivariance.R
\name{as.matrix.semivariance}
\alias{as.matrix.semivariance}
\alias{as.data.frame.semivariance}
\title{Convert semivariance to a matrix object}
\usage{
\method{as.matrix}{semivariance}(x, ...)

\method{as.data.frame}{semivariance}(x, ...)
}
\arguments{
\item{x}{An \code{semivariance} object created by \code{semivariance} or 
\code{exponential.semivariance}.}

\item{\dots}{Additional arguments passed to \code{as.matrix} and \code{as.data.frame}
methods. Not supported for \code{semivariance} object.}
}
\value{
A matrix containing the computed distance and semivariance.
}
\description{
Convert semivariance to a matrix object
}
\details{
The defaults of semivariance methods give a list or numeric vector. These
  methods can convert the semivariance output list and vector to \code{matrix} or 
  \code{data.frame}.
}
\examples{
\dontrun{
# Summarize Data
summary(ContrivedData)

# Empirical semivariance for variable y
raw.var <- semivariance(x=ContrivedData$y,coords = cbind(ContrivedData$s.1, 
  ContrivedData$s.2))
as.matrix(raw.var)

# Estimation using metropolis.krige()
#' # Set seed
set.seed(1241060320)

M <- 100
#M<-10000

contrived.run <- metropolis.krige(y ~ x.1 + x.2, coords = c("s.1","s.2"), 
   data = ContrivedData, n.iter = M, range.tol = 0.05)

# Parametric semivariance
parametric.var <- semivariance(contrived.run)
as.matrix(parametric.var)
as.data.frame(parametric.var)
}

}
