% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/kmod.R
\name{kmod}
\alias{kmod}
\title{K-Means clustering with simultaneous Outlier Detection}
\usage{
kmod(X, k = 5, l = 0, i_max = 100, conv_method = "delta_C",
  conv_error = 0, allow_empty_c = FALSE)
}
\arguments{
\item{X}{matrix of numeric data or an object that can be coerced
to such a matrix (such as a data frame with numeric columns only).}

\item{k}{the number of clusters (default = 5)}

\item{l}{the number of outliers (default = 0)}

\item{i_max}{the maximum number of iterations permissible
(default = 100)}

\item{conv_method}{character: the method used to assess
if kmod has converged (default = "delta_C")}

\item{conv_error}{numeric: the tolerence permissible when
assessing convergence (default = 0)}

\item{allow_empty_c}{logical: set whether empty clusters are
permissible (default = FALSE)}
}
\value{
kmod returns a list comprising the following components
@return \code{k} the number of clusters specified

\code{l} the number of outliers specified

\code{C} the set of cluster centroids

\code{C_sizes} cluster sizes

\code{C_ss} the sum of squares for each cluster

\code{L} the set of outliers

\code{L_dist_sqr} the distance squares for each outlier to C

\code{L_index} the index of each outlier in the supplied dataset

\code{XC_dist_sqr_assign} the distance square and cluster assignment
of each point in the supplied dataset

\code{within_ss} the within cluster sum of squares (excludes outliers)

\code{between_ss} the between cluster sum of squares

\code{tot_ss} the total sum of squares

\code{iterations} the number of iterations taken to converge
}
\description{
K-Means clustering with simultaneous Outlier Detection
}
\examples{
# a 2-dimensional example with 2 clusters and 5 outliers
x <- rbind(matrix(rnorm(100, sd = 0.3), ncol = 2),
           matrix(rnorm(100, mean = 1, sd = 0.3), ncol = 2))
colnames(x) <- c("x", "y")
(cl <- kmod(x, 2, 5))

# cluster a dataset with 8 clusters and 0 outliers
x <- kmod(x, 8)
}

