% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kittyR.R
\name{kittyR}
\alias{kittyR}
\title{Cats in R console.}
\usage{
kittyR(url = NULL, meow = TRUE, sound = 3, only_kitten = FALSE, ...)
}
\arguments{
\item{url}{URL for the source from which individual image URLs are to be
extracted. Default is \code{NULL}. If \code{NULL}, a randomly drawn image from the
default collection will be shown.}

\item{meow}{Logical that decides whether to play a meow sound along with the
picture of a cat.}

\item{sound}{A character string or a number specifying what sound to be
played by either specifying one of the built in sounds, specifying the path
to a \code{.wav} file or specifying an url. There are currently 6 meows
included. The default is \code{3}.}

\item{only_kitten}{Logical that decides whether only kitten pics should be
selected (default: \code{FALSE}).}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A photo of a cat is downloaded and displayed in the plot window.
}
\description{
\Sexpr[results=rd, stage=render]{rlang:::lifecycle("stable")}

This function displays a picture of a cat and plays a short sound clip
containing cat meow.

Currently, the images are collected from the following sources-
\enumerate{
\item \url{https://unsplash.com/s/photos/cat/}
\item \url{https://www.reshot.com/search/cat/}
\item \url{https://unsplash.com/s/photos/kitten/}
\item \url{https://www.reshot.com/search/kitten/}
}

The sound files come from the following CC BY 3.0 source:
\url{https://soundbible.com/suggest.php?q=cat+meow&x=0&y=0}
}
\examples{
\donttest{
# relying on default collection
set.seed(122)
kittyR::kittyR(meow = FALSE)

# in case you want only pics of kittens
set.seed(111)
kittyR::kittyR(meow = FALSE, only_kitten = TRUE)

# provide a custom URL
set.seed(300)
kittyR::kittyR(
  url = "https://unsplash.com/s/photos/cat/",
  meow = FALSE
)
}
}
\author{
\href{https://github.com/IndrajeetPatil/}{Indrajeet Patil}
}
