% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assume.R
\name{lock_coverage}
\alias{lock_coverage}
\title{Assert minimum coverage of values}
\usage{
lock_coverage(.data, threshold, ..., .strict = FALSE)
}
\arguments{
\item{.data}{A data frame.}

\item{threshold}{Minimum fraction of non-NA values (0 to 1).}

\item{...}{Column names (unquoted) to check. If empty, checks all columns.}

\item{.strict}{If \code{TRUE}, error on failure. If \code{FALSE} (default), warn.}
}
\value{
Invisibly returns \code{.data} (for piping).
}
\description{
Checks that the fraction of non-NA values meets a threshold.
Useful after joins to verify expected coverage.
}
\examples{
df <- data.frame(id = 1:10, x = c(1:8, NA, NA))
lock_coverage(df, 0.8, x)
lock_coverage(df, 0.9, x)  # warns (only 80\% coverage)

}
