% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{ks_extract}
\alias{ks_extract}
\alias{ks_extract.kernelshap}
\alias{ks_extract.default}
\title{Extractor Function}
\usage{
ks_extract(object, ...)

\method{ks_extract}{kernelshap}(
  object,
  what = c("S", "X", "baseline", "SE", "n_iter", "converged"),
  ...
)

\method{ks_extract}{default}(object, ...)
}
\arguments{
\item{object}{Object to extract something.}

\item{...}{Currently unused.}

\item{what}{Element to extract. One of "S", "X", "baseline", "SE", "n_iter", or "converged".}
}
\value{
The corresponding object is returned.
}
\description{
Function to extract an element of a "kernelshap" object, e.g., the SHAP values "S".
}
\section{Methods (by class)}{
\itemize{
\item \code{ks_extract(kernelshap)}: Method for "kernelshap" object.

\item \code{ks_extract(default)}: No default method available.

}}
\examples{
fit <- stats::lm(Sepal.Length ~ ., data = iris)
s <- kernelshap(fit, iris[1:2, -1], bg_X = iris[-1])
ks_extract(s, what = "S")
}
