% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topological_kernels.R
\name{pf.kernel}
\alias{pf.kernel}
\title{Persistence Fisher Kernel (PFK)}
\usage{
pf.kernel(d1, d2 = NULL, h, dimension, sigma)
}
\arguments{
\item{d1}{A persistence diagram (matrix with 3 col where the first one is the dimension, the second is the birth-time and the third is the death-time) or a list of diagrams.}

\item{d2}{A persistence diagram (matrix with 3 col where the first one is the dimension, the second is the birth-time and the third is the death-time).}

\item{h}{bandwidth of the PFK.}

\item{dimension}{The dimension of the topological feature (0 for connected components, 1 for cycles etc)}

\item{sigma}{standard deviation of the base Gaussian Kernel.}
}
\value{
If \code{d1} is a list of Persistence Diagrams, this function returns a matrix whose (i,j) entry is the PFK computed in (\code{d1}[[i]], \code{d2}[[j]]),
otherwise it returns the value for the PFK computed in (\code{d1}, \code{d2}).
}
\description{
Computes the Persistence Fisher Kernel (PFK) between persistence diagrams.
}
\examples{
diag1 <- matrix(c(1,1,1,0,2,3,2,2.5,4), ncol = 3, byrow = FALSE)
diag2 <- matrix(c(1,1,0,1,1,2), ncol = 3, byrow = FALSE)
pf.kernel(d1 = diag1, d2 = diag2, h = 1, dimension = 1, sigma = 1)
}
\references{
\insertRef{le2018persistence}{kernelTDA}
}
\author{
Tullia Padellini
}
