% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaseTuner.R
\name{BaseTuner}
\alias{BaseTuner}
\title{Base Tuner}
\usage{
BaseTuner(
  oracle,
  hypermodel,
  directory = NULL,
  project_name = NULL,
  logger = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{oracle}{Instance of Oracle class.}

\item{hypermodel}{Instance of HyperModel class (or callable that takes 
hyperparameters and returns a Model instance).}

\item{directory}{String. Path to the working directory (relative).}

\item{project_name}{Name to use as prefix for files saved by this Tuner.}

\item{logger}{Optional. Instance of Logger class, used for streaming 
data to Cloud Service for monitoring.}

\item{overwrite}{Bool, default `FALSE`. If `FALSE`, reloads an existing 
project of the same name if one is found. Otherwise, overwrites the project.}
}
\value{
base tuner object
}
\description{
Tuner base class.
}
\details{
May be subclassed to create new tuners, including for non-Keras models.
}
