% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{Predict}
\alias{Predict}
\alias{keras_predict}
\alias{keras_predict_classes}
\alias{keras_predict_proba}
\title{Predict values from a keras model}
\usage{
keras_predict(model, x, batch_size = 32, verbose = 1)

keras_predict_classes(model, x, batch_size = 32, verbose = 1)

keras_predict_proba(model, x, batch_size = 32, verbose = 1)
}
\arguments{
\item{model}{a keras model object, for example created with \code{\link[=Sequential]{Sequential()}}}

\item{x}{input data}

\item{batch_size}{integer. Number of samples per gradient update.}

\item{verbose}{0 for no logging to stdout, 1 for progress bar
logging, 2 for one log line per epoch.}
}
\description{
Once compiled and trained, this function returns the predictions
from a keras model. The function \link{keras_predict} returns raw
predictions, \link{keras_predict_classes} gives class predictions, and
\link{keras_predict_proba} gives class probabilities.
}
\examples{
if(keras_available()) {
  X_train <- matrix(rnorm(100 * 10), nrow = 100)
  Y_train <- to_categorical(matrix(sample(0:2, 100, TRUE), ncol = 1), 3)
  
  mod <- Sequential()
  mod$add(Dense(units = 50, input_shape = dim(X_train)[2]))
  mod$add(Dropout(rate = 0.5))
  mod$add(Activation("relu"))
  mod$add(Dense(units = 3))
  mod$add(ActivityRegularization(l1 = 1))
  mod$add(Activation("softmax"))
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = RMSprop())
  
  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, validation_split = 0.2)
  dim(keras_predict(mod, X_train))
  mean(keras_predict(mod, X_train) == (apply(Y_train, 1, which.max) - 1))
}
}
\references{
Chollet, Francois. 2015. \href{https://keras.io/}{Keras: Deep Learning library for Theano and TensorFlow}.
}
\seealso{
Other model functions: \code{\link{LoadSave}},
  \code{\link{Sequential}}, \code{\link{keras_compile}},
  \code{\link{keras_fit}}
}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
