% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regularizers.R
\name{regularizer_l1_l2}
\alias{regularizer_l1_l2}
\title{A regularizer that applies both L1 and L2 regularization penalties.}
\usage{
regularizer_l1_l2(l1 = 0, l2 = 0)
}
\arguments{
\item{l1}{float, L1 regularization factor.}

\item{l2}{float, L2 regularization factor.}
}
\value{
A \code{Regularizer} instance that can be passed to layer constructors or
used as a standalone object.
}
\description{
The L1 regularization penalty is computed as:
\code{loss = l1 * reduce_sum(abs(x))}

The L2 regularization penalty is computed as
\code{loss = l2 * reduce_sum(square(x))}

L1L2 may be passed to a layer as a string identifier:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dense <- layer_dense(units = 3, kernel_regularizer = 'L1L2')
}\if{html}{\out{</div>}}

In this case, the default values used are \code{l1=0.01} and \code{l2=0.01}.
}
\seealso{
\itemize{
\item \url{https://keras.io/api/layers/regularizers#l1l2-class}
}

Other regularizers: \cr
\code{\link{regularizer_l1}()} \cr
\code{\link{regularizer_l2}()} \cr
\code{\link{regularizer_orthogonal}()} \cr
}
\concept{regularizers}
