% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keras3-package.R, R/package.R
\docType{package}
\name{keras3-package}
\alias{keras3-package}
\title{keras3: R Interface to 'Keras'}
\description{
Interface to 'Keras' \url{https://keras.io}, a high-level neural networks API. 'Keras' was developed with a focus on enabling fast experimentation, supports both convolution based networks and recurrent networks (as well as combinations of the two), and runs seamlessly on both CPU and GPU devices.

Keras is a high-level neural networks API, developed with a focus on enabling
fast experimentation. Keras has the following key features:
}
\details{
\itemize{
\item Allows the same code to run on CPU or on GPU, seamlessly.
\item User-friendly API which makes it easy to quickly prototype deep learning models.
\item Built-in support for convolutional networks (for computer vision), recurrent
networks (for sequence processing), and any combination of both.
\item Supports arbitrary network architectures: multi-input or multi-output models,
layer sharing, model sharing, etc. This means that Keras is appropriate for
building essentially any deep learning model, from a memory network to a neural
Turing machine.
\item Is capable of running on top of multiple back-ends including
\href{https://github.com/tensorflow/tensorflow}{TensorFlow},
\href{https://github.com/jax-ml/jax}{Jax},
or \href{https://github.com/pytorch/pytorch}{PyTorch}.
}

See the package website at \url{https://keras3.posit.co} for complete documentation.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://keras3.posit.co/}
  \item \url{https://github.com/rstudio/keras3}
  \item Report bugs at \url{https://github.com/rstudio/keras3/issues}
}


Useful links:
\itemize{
  \item \url{https://keras3.posit.co/}
  \item \url{https://github.com/rstudio/keras3}
  \item Report bugs at \url{https://github.com/rstudio/keras3/issues}
}

}
\author{
\strong{Maintainer}: Tomasz Kalinowski \email{tomasz@posit.co} [copyright holder]

Authors:
\itemize{
  \item JJ Allaire [copyright holder]
  \item François Chollet [copyright holder]
}

Other contributors: \cr
\itemize{
  \item Daniel Falbel \email{daniel@posit.co} [contributor, copyright holder]
  \item Posit Software, PBC [copyright holder, funder]
  \item Google [copyright holder, funder]
  \item Yuan Tang \email{terrytangyuan@gmail.com} (\href{https://orcid.org/0000-0001-5243-233X}{ORCID}) [contributor, copyright holder]
  \item Wouter Van Der Bijl [contributor, copyright holder]
  \item Martin Studer [contributor, copyright holder]
  \item Sigrid Keydana [contributor]
}

}
\keyword{internal}
