% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-preprocessing.R
\name{layer_random_translation}
\alias{layer_random_translation}
\title{Randomly translate each image during training}
\usage{
layer_random_translation(
  object,
  height_factor,
  width_factor,
  fill_mode = "reflect",
  interpolation = "bilinear",
  seed = NULL,
  fill_value = 0,
  ...
)
}
\arguments{
\item{object}{What to compose the new \code{Layer} instance with. Typically a
Sequential model or a Tensor (e.g., as returned by \code{layer_input()}).
The return value depends on \code{object}. If \code{object} is:
\itemize{
\item missing or \code{NULL}, the \code{Layer} instance is returned.
\item a \code{Sequential} model, the model with an additional layer is returned.
\item a Tensor, the output tensor from \code{layer_instance(object)} is returned.
}}

\item{height_factor}{a float represented as fraction of value, or a list of size
2 representing lower and upper bound for shifting vertically. A negative
value means shifting image up, while a positive value means shifting image
down. When represented as a single positive float, this value is used for
both the upper and lower bound. For instance, \code{height_factor = c(-0.2, 0.3)}
results in an output shifted by a random amount in the range
\verb{[-20\%, +30\%]}.
\code{height_factor = 0.2} results in an output height shifted by a random amount
in the range \verb{[-20\%, +20\%]}.}

\item{width_factor}{a float represented as fraction of value, or a list of size 2
representing lower and upper bound for shifting horizontally. A negative
value means shifting image left, while a positive value means shifting
image right. When represented as a single positive float, this value is
used for both the upper and lower bound. For instance,
\code{width_factor = c(-0.2, 0.3)} results in an output shifted left by 20\%, and
shifted right by 30\%. \code{width_factor = 0.2} results in an output height
shifted left or right by 20\%.}

\item{fill_mode}{Points outside the boundaries of the input are filled according
to the given mode (one of \verb{\{"constant", "reflect", "wrap", "nearest"\}}).
\itemize{
\item \emph{reflect}: \verb{(d c b a | a b c d | d c b a)} The input is extended by
reflecting about the edge of the last pixel.
\item \emph{constant}: \verb{(k k k k | a b c d | k k k k)} The input is extended by
filling all values beyond the edge with the same constant value k = 0.
\item \emph{wrap}: \verb{(a b c d | a b c d | a b c d)} The input is extended by
wrapping around to the opposite edge.
\item \emph{nearest}: \verb{(a a a a | a b c d | d d d d)} The input is extended by the
nearest pixel.
}}

\item{interpolation}{Interpolation mode. Supported values: \code{"nearest"},
\code{"bilinear"}.}

\item{seed}{Integer. Used to create a random seed.}

\item{fill_value}{a float represents the value to be filled outside the boundaries
when \code{fill_mode="constant"}.}

\item{...}{standard layer arguments.}
}
\description{
Randomly translate each image during training
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/RandomTranslation}
\item \url{https://keras.io/api/layers/preprocessing_layers/}
}

Other image augmentation layers: 
\code{\link{layer_random_contrast}()},
\code{\link{layer_random_crop}()},
\code{\link{layer_random_flip}()},
\code{\link{layer_random_height}()},
\code{\link{layer_random_rotation}()},
\code{\link{layer_random_width}()},
\code{\link{layer_random_zoom}()}

Other preprocessing layers: 
\code{\link{layer_category_encoding}()},
\code{\link{layer_center_crop}()},
\code{\link{layer_discretization}()},
\code{\link{layer_hashing}()},
\code{\link{layer_integer_lookup}()},
\code{\link{layer_normalization}()},
\code{\link{layer_random_contrast}()},
\code{\link{layer_random_crop}()},
\code{\link{layer_random_flip}()},
\code{\link{layer_random_height}()},
\code{\link{layer_random_rotation}()},
\code{\link{layer_random_width}()},
\code{\link{layer_random_zoom}()},
\code{\link{layer_rescaling}()},
\code{\link{layer_resizing}()},
\code{\link{layer_string_lookup}()},
\code{\link{layer_text_vectorization}()}
}
\concept{image augmentation layers}
\concept{preprocessing layers}
