% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-text_vectorization.R
\name{set_vocabulary}
\alias{set_vocabulary}
\title{Sets vocabulary (and optionally document frequency) data for the layer}
\usage{
set_vocabulary(
  object,
  vocab,
  df_data = NULL,
  oov_df_value = FALSE,
  append = FALSE
)
}
\arguments{
\item{object}{a text vectorization layer}

\item{vocab}{An array of string tokens.}

\item{df_data}{An array of document frequency data. Only necessary if the layer
output_mode is "tfidf".}

\item{oov_df_value}{The document frequency of the OOV token. Only necessary if
output_mode is "tfidf". OOV data is optional when appending additional
data in "tfidf" mode; if an OOV value is supplied it will overwrite the
existing OOV value.}

\item{append}{Whether to overwrite or append any existing vocabulary data.}
}
\description{
This method sets the vocabulary and DF data for this layer directly, instead
of analyzing a dataset through \code{\link[=adapt]{adapt()}}. It should be used whenever the \code{vocab}
(and optionally document frequency) information is already known. If
vocabulary data is already present in the layer, this method will either
replace it, if \code{append} is set to \code{FALSE}, or append to it (if 'append' is set
to \code{TRUE})
}
\seealso{
\code{\link[=get_vocabulary]{get_vocabulary()}}
}
