% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseries.R
\name{timeseries_generator}
\alias{timeseries_generator}
\title{Utility function for generating batches of temporal data.}
\usage{
timeseries_generator(data, targets, length, sampling_rate = 1,
  stride = 1, start_index = 0, end_index = NULL, shuffle = FALSE,
  reverse = FALSE, batch_size = 128)
}
\arguments{
\item{data}{Object containing consecutive data points (timesteps). The data
should be 2D, and axis 1 is expected to be the time dimension.}

\item{targets}{Targets corresponding to timesteps in \code{data}.
It should have same length as \code{data}.}

\item{length}{Length of the output sequences (in number of timesteps).}

\item{sampling_rate}{Period between successive individual timesteps
within sequences. For rate \code{r}, timesteps \code{data[i]}, \code{data[i-r]}, ... \code{data[i - length]}
are used for create a sample sequence.}

\item{stride}{Period between successive output sequences.
For stride \code{s}, consecutive output samples would
be centered around \code{data[i]}, \code{data[i+s]}, \code{data[i+2*s]}, etc.}

\item{start_index, end_index}{Data points earlier than \code{start_index}
or later than \code{end_index} will not be used in the output sequences.
This is useful to reserve part of the data for test or validation.}

\item{shuffle}{Whether to shuffle output samples,
or instead draw them in chronological order.}

\item{reverse}{Boolean: if \code{true}, timesteps in each output sample will be
in reverse chronological order.}

\item{batch_size}{Number of timeseries samples in each batch
(except maybe the last one).}
}
\value{
An object that can be passed to generator based training
functions (e.g. \code{\link[=fit_generator]{fit_generator()}}).ma
}
\description{
Utility function for generating batches of temporal data.
}
