% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{flow_images_from_data}
\alias{flow_images_from_data}
\title{Generates batches of augmented/normalized data from image data and labels}
\usage{
flow_images_from_data(x, y = NULL, generator = image_data_generator(),
  batch_size = 32, shuffle = TRUE, sample_weight = NULL,
  seed = NULL, save_to_dir = NULL, save_prefix = "",
  save_format = "png", subset = NULL)
}
\arguments{
\item{x}{data. Should have rank 4. In case of grayscale data, the channels
axis should have value 1, and in case of RGB data, it should have value 3.}

\item{y}{labels (can be \code{NULL} if no labels are required)}

\item{generator}{Image data generator to use for augmenting/normalizing image
data.}

\item{batch_size}{int (default: \code{32}).}

\item{shuffle}{boolean (defaut: \code{TRUE}).}

\item{sample_weight}{Sample weights.}

\item{seed}{int (default: \code{NULL}).}

\item{save_to_dir}{\code{NULL} or str (default: \code{NULL}). This allows you to
optionally specify a directory to which to save the augmented pictures being
generated (useful for visualizing what you are doing).}

\item{save_prefix}{str (default: ''). Prefix to use for filenames of saved
pictures (only relevant if \code{save_to_dir} is set).}

\item{save_format}{one of "png", "jpeg" (only relevant if save_to_dir is
set). Default: "png".}

\item{subset}{Subset of data (\code{"training"} or \code{"validation"}) if
\code{validation_split} is set in \code{\link[=image_data_generator]{image_data_generator()}}.}
}
\description{
Generates batches of augmented/normalized data from image data and labels
}
\details{
Yields batches indefinitely, in an infinite loop.
}
\section{Yields}{
 \code{(x, y)} where \code{x} is an array of image data and \code{y} is a
array of corresponding labels. The generator loops indefinitely.
}

\seealso{
Other image preprocessing: \code{\link{fit_image_data_generator}},
  \code{\link{flow_images_from_directory}},
  \code{\link{image_load}}, \code{\link{image_to_array}}
}
\concept{image preprocessing}
