% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_batch_dot}
\alias{k_batch_dot}
\title{Batchwise dot product.}
\usage{
k_batch_dot(x, y, axes)
}
\arguments{
\item{x}{Keras tensor or variable with 2 more more axes.}

\item{y}{Keras tensor or variable with 2 or more axes}

\item{axes}{List of (or single) integer with target dimensions (axis indexes
are 1-based). The lengths of \code{axes[[1]]} and \code{axes[[2]]} should be the
same.

[[1]: R:[1
[[2]: R:[2}
}
\value{
A tensor with shape equal to the concatenation of \code{x}'s shape (less
the dimension that was summed over) and \code{y}'s shape (less the batch
dimension and the dimension that was summed over). If the final rank is 1,
we reshape it to \code{(batch_size, 1)}.
}
\description{
\code{batch_dot} is used to compute dot product of \code{x} and \code{y} when \code{x} and \code{y}
are data in batch, i.e. in a shape of \code{(batch_size)}. \code{batch_dot} results in
a tensor or variable with less dimensions than the input. If the number of
dimensions is reduced to 1, we use \code{expand_dims} to make sure that ndim is
at least 2.
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://keras.rstudio.com/articles/backend.html#backend-functions}.
}

