% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_placeholder}
\alias{k_placeholder}
\title{Instantiates a placeholder tensor and returns it.}
\usage{
k_placeholder(
  shape = NULL,
  ndim = NULL,
  dtype = NULL,
  sparse = FALSE,
  name = NULL
)
}
\arguments{
\item{shape}{Shape of the placeholder (integer list, may include \code{NULL}
entries).}

\item{ndim}{Number of axes of the tensor. At least one of \code{shape} or \code{ndim}
must be specified. If both are specified, \code{shape} is used.}

\item{dtype}{Placeholder type.}

\item{sparse}{Logical, whether the placeholder should have a sparse type.}

\item{name}{Optional name string for the placeholder.}
}
\value{
Tensor instance (with Keras metadata included).
}
\description{
Instantiates a placeholder tensor and returns it.
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://tensorflow.rstudio.com/reference/keras/index.html#backend}.
}

