% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-pooling.R
\name{layer_global_max_pooling_3d}
\alias{layer_global_max_pooling_3d}
\title{Global Max pooling operation for 3D data.}
\usage{
layer_global_max_pooling_3d(object, data_format = NULL, batch_size = NULL,
  name = NULL, trainable = NULL, weights = NULL)
}
\arguments{
\item{object}{Model or layer object}

\item{data_format}{A string, one of \code{channels_last} (default) or
\code{channels_first}. The ordering of the dimensions in the inputs.
\code{channels_last} corresponds to inputs with shape \code{(batch, spatial_dim1, spatial_dim2, spatial_dim3, channels)} while \code{channels_first} corresponds
to inputs with shape \code{(batch, channels, spatial_dim1, spatial_dim2, spatial_dim3)}. It defaults to the \code{image_data_format} value found in your
Keras config file at \code{~/.keras/keras.json}. If you never set it, then it
will be "channels_last".}

\item{batch_size}{Fixed batch size for layer}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
Global Max pooling operation for 3D data.
}
\section{Input shape}{

\itemize{
\item If \code{data_format='channels_last'}: 5D tensor with shape: \code{(batch_size, spatial_dim1, spatial_dim2, spatial_dim3, channels)}
\item If \code{data_format='channels_first'}: 5D tensor with shape: \code{(batch_size, channels, spatial_dim1, spatial_dim2, spatial_dim3)}
}
}

\section{Output shape}{
 2D tensor with shape: \code{(batch_size, channels)}
}

\seealso{
Other pooling layers: \code{\link{layer_average_pooling_1d}},
  \code{\link{layer_average_pooling_2d}},
  \code{\link{layer_average_pooling_3d}},
  \code{\link{layer_global_average_pooling_1d}},
  \code{\link{layer_global_average_pooling_2d}},
  \code{\link{layer_global_average_pooling_3d}},
  \code{\link{layer_global_max_pooling_1d}},
  \code{\link{layer_global_max_pooling_2d}},
  \code{\link{layer_max_pooling_1d}},
  \code{\link{layer_max_pooling_2d}},
  \code{\link{layer_max_pooling_3d}}
}
