% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-convolutional.R
\name{layer_conv_lstm_2d}
\alias{layer_conv_lstm_2d}
\title{Convolutional LSTM.}
\usage{
layer_conv_lstm_2d(object, filters, kernel_size, strides = c(1L, 1L),
  padding = "valid", data_format = NULL, dilation_rate = c(1L, 1L),
  activation = "tanh", recurrent_activation = "hard_sigmoid",
  use_bias = TRUE, kernel_initializer = "glorot_uniform",
  recurrent_initializer = "orthogonal", bias_initializer = "zeros",
  unit_forget_bias = TRUE, kernel_regularizer = NULL,
  recurrent_regularizer = NULL, bias_regularizer = NULL,
  activity_regularizer = NULL, kernel_constraint = NULL,
  recurrent_constraint = NULL, bias_constraint = NULL,
  return_sequences = FALSE, go_backwards = FALSE, stateful = FALSE,
  dropout = 0, recurrent_dropout = 0, batch_size = NULL, name = NULL,
  trainable = NULL, weights = NULL, input_shape = NULL)
}
\arguments{
\item{object}{Model or layer object}

\item{filters}{Integer, the dimensionality of the output space (i.e. the
number output of filters in the convolution).}

\item{kernel_size}{An integer or list of n integers, specifying the
dimensions of the convolution window.}

\item{strides}{An integer or list of n integers, specifying the strides of
the convolution. Specifying any stride value != 1 is incompatible with
specifying any \code{dilation_rate} value != 1.}

\item{padding}{One of \code{"valid"} or \code{"same"} (case-insensitive).}

\item{data_format}{A string, one of \code{channels_last} (default) or
\code{channels_first}. The ordering of the dimensions in the inputs.
\code{channels_last} corresponds to inputs with shape \code{(batch, time, ..., channels)} while \code{channels_first} corresponds to inputs with shape \code{(batch, time, channels, ...)}. It defaults to the \code{image_data_format} value found
in your Keras config file at \code{~/.keras/keras.json}. If you never set it,
then it will be "channels_last".}

\item{dilation_rate}{An integer or list of n integers, specifying the
dilation rate to use for dilated convolution. Currently, specifying any
\code{dilation_rate} value != 1 is incompatible with specifying any \code{strides}
value != 1.}

\item{activation}{Activation function to use. If you don't specify anything,
no activation is applied (ie. "linear" activation: \code{a(x) = x}).}

\item{recurrent_activation}{Activation function to use for the recurrent
step.}

\item{use_bias}{Boolean, whether the layer uses a bias vector.}

\item{kernel_initializer}{Initializer for the \code{kernel} weights matrix, used
for the linear transformation of the inputs..}

\item{recurrent_initializer}{Initializer for the \code{recurrent_kernel} weights
matrix, used for the linear transformation of the recurrent state..}

\item{bias_initializer}{Initializer for the bias vector.}

\item{unit_forget_bias}{Boolean. If TRUE, add 1 to the bias of the forget
gate at initialization. Use in combination with \code{bias_initializer="zeros"}.
This is recommended in \href{http://www.jmlr.org/proceedings/papers/v37/jozefowicz15.pdf}{Jozefowicz etal.}}

\item{kernel_regularizer}{Regularizer function applied to the \code{kernel}
weights matrix.}

\item{recurrent_regularizer}{Regularizer function applied to the
\code{recurrent_kernel} weights matrix.}

\item{bias_regularizer}{Regularizer function applied to the bias vector.}

\item{activity_regularizer}{Regularizer function applied to the output of the
layer (its "activation")..}

\item{kernel_constraint}{Constraint function applied to the \code{kernel} weights
matrix.}

\item{recurrent_constraint}{Constraint function applied to the
\code{recurrent_kernel} weights matrix.}

\item{bias_constraint}{Constraint function applied to the bias vector.}

\item{return_sequences}{Boolean. Whether to return the last output in the
output sequence, or the full sequence.}

\item{go_backwards}{Boolean (default FALSE). If TRUE, rocess the input
sequence backwards.}

\item{stateful}{Boolean (default FALSE). If TRUE, the last state for each
sample at index i in a batch will be used as initial state for the sample
of index i in the following batch.}

\item{dropout}{Float between 0 and 1. Fraction of the units to drop for the
linear transformation of the inputs.}

\item{recurrent_dropout}{Float between 0 and 1. Fraction of the units to drop
for the linear transformation of the recurrent state.}

\item{batch_size}{Fixed batch size for layer}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}

\item{input_shape}{Dimensionality of the input (integer) not including the
samples axis. This argument is required when using this layer as the first
layer in a model.}
}
\description{
It is similar to an LSTM layer, but the input transformations and recurrent
transformations are both convolutional.
}
\section{Input shape}{

\itemize{
\item if data_format='channels_first' 5D tensor with shape:
\code{(samples,time, channels, rows, cols)}
\itemize{
\item if data_format='channels_last' 5D
tensor with shape: \code{(samples,time, rows, cols, channels)}
}
}
}

\section{References}{

\itemize{
\item \href{http://arxiv.org/abs/1506.04214v1}{Convolutional LSTM Network: A Machine Learning Approach for Precipitation Nowcasting}
The current implementation does not include the feedback loop on the cells
output
}
}

\seealso{
Other convolutional layers: \code{\link{layer_conv_1d}},
  \code{\link{layer_conv_2d_transpose}},
  \code{\link{layer_conv_2d}},
  \code{\link{layer_conv_3d_transpose}},
  \code{\link{layer_conv_3d}},
  \code{\link{layer_cropping_1d}},
  \code{\link{layer_cropping_2d}},
  \code{\link{layer_cropping_3d}},
  \code{\link{layer_separable_conv_2d}},
  \code{\link{layer_upsampling_1d}},
  \code{\link{layer_upsampling_2d}},
  \code{\link{layer_upsampling_3d}},
  \code{\link{layer_zero_padding_1d}},
  \code{\link{layer_zero_padding_2d}},
  \code{\link{layer_zero_padding_3d}}
}
