% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_multi.R
\name{match_multi}
\alias{match_multi}
\title{Match across columns for multiple lookup values}
\usage{
match_multi(x, cols, table, incomparables = NULL)
}
\arguments{
\item{x}{data.frame}

\item{cols}{character vector of column names to be found in \code{x}}

\item{table}{vector of items to find}

\item{incomparables}{passed on to the base function \code{match}}
}
\value{
matrix with same number of rows as \code{x}, and a column for each of
\code{cols}
}
\description{
This provides a succinct way to query a data frame for conditions, which is
otherwise very verbose in base R or dplyr
}
\examples{
j <- cars[1:10, ]
match_multi(j, "speed", 7)
match_multi(j, "dist", 22)
match_multi(j, c("speed", "dist"), 10)
match_multi(j, c("speed", "dist"), c(7, 17))
}
