% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/transeq.R
\name{transeq}
\alias{transeq}
\alias{transeq.sb}
\alias{transeq.su}
\title{Export the transformation equation into LaTeX}
\usage{
transeq(obj, digits = 4)

\method{transeq}{sb}(obj, digits)

\method{transeq}{su}(obj, digits)
}
\arguments{
\item{obj}{a \code{jtrans} object with a specific transformation type}

\item{digits}{digits displayed in the equation}
}
\description{
\code{transeq} turns a \code{jtrans} object into a LaTeX equation for
display.
}
\details{
A LaTeX equation in the display mode, e.g. between \code{\\[} and \code{\\]}
is returned with the formula used in the transformation. Note that when it's
displayed in the R console, the backslashes are escaped. So it's always
double backslash when in print it in the terminal.

This is designed to work with \pkg{knitr} and \pkg{rmarkdown}. In this
case you can set the chunk option \code{results='asis'} and output it to a
PDF document. Then the LaTeX equation will be properly formatted and can be
easily included in your report.
}
\examples{
\dontrun{
# designed to be used with R Markdown and chunk options
```{r, results='asis'}
library(jtrans)
jt <- jtrans(rexp(30, .3))
transeq(jt)
```
}
}

