% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_compile.R
\name{compile}
\alias{compile}
\alias{compile.cpt_list}
\title{Compile information}
\usage{
compile(
  x,
  root_node = "",
  joint_vars = NULL,
  save_graph = FALSE,
  opt = "min_fill"
)

\method{compile}{cpt_list}(
  x,
  root_node = "",
  joint_vars = NULL,
  save_graph = FALSE,
  opt = "min_fill"
)
}
\arguments{
\item{x}{An object returned from \code{cpt_list}}

\item{root_node}{A node for which we require it to live in the root
clique (the first clique)}

\item{joint_vars}{A vector of variables for which we require to be in
the same clique}

\item{save_graph}{Logical.}

\item{opt}{The optimization strategy used for triangulation. Either
'min_fill' or 'min_sp'}
}
\description{
Compiled objects are used as building blocks for junction tree inference
}
\details{
The Junction Tree Algorithm performs both a forward and inward
message passsing (collect and distribute). However, when the forward
phase is finish, the root clique potential is guaranteed to be the
joint pmf over the variables involved in the root clique. Thus, if
it is known in advance that a specific variable is of interest, the
algortihm can be terminated after the forward phase. Use the \code{root_node}
to specify such a variable.

Moreover, if interest is in some joint pmf for variables that end up
being in different cliques these variables must be specified in advance
using the \code{joint_vars} argument. The compilation step then
adds edges between all of these variables to ensure that at least one
clique contains all of them.
}
\examples{
cptl <- cpt_list(asia2)
compile(cptl, joint_vars = c("bronc", "tub"))
}
