% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/journal_info.R
\name{jst_get_journal_overview}
\alias{jst_get_journal_overview}
\title{Get table with information on journals}
\usage{
jst_get_journal_overview(most_recent = FALSE, quiet = FALSE)
}
\arguments{
\item{most_recent}{Should the most recent version be downloaded from DfR?
(Currently disabled due to changes on the JSTOR-servers).}

\item{quiet}{Should status messages about the download be printed?}
}
\value{
A \code{tibble} with various information about journals.
}
\description{
Download most recent or display cached version of data on journals.
}
\details{
When analysing your sample of articles from DfR, it might be helpful to have
some context about the journals in your sample. This function provides a
\code{tibble} with various information like the full name of the journal, the
short version of the name (sometimes referred to as \code{JCODE}), dates on where
the first
and last (available) issues were published, etc.

The data on journals might change. Therefore this function provides two
sources of data: a cached version which gets updated with every release, and
the ability to pull the most recent version directly from DfR (this had to
be temporarily disabled.)

The cached version was updated on 2020-04-03.
}
\examples{
# use the function without arguments to get a tibble from disk
jst_get_journal_overview()

\dontrun{
# download the most recent version from DfR
jst_get_journal_overview(most_recent = TRUE)
}
}
